; Define some constants
#define IX_EXCEPTION  		0
#define SA_CONSUME_NUM     31
#define SEQNUM_IGNORE	   31

; Define variables that are global for the dispatch loop
.local 	dl_reg1 dl_reg2 dl_reg3 dl_reg4 dl_buffer_handle dl_next_block

#include "DispatchLoop_h.uc"
#include "DispatchLoopImportVars.h"
#include "EthernetIngress.uc"
#include "SimpleImportVars.h"

; Do initialization
DL_Init[]
EthernetIngress_Init[]

; Run the dispatch loop
.while(1)
dl_start#:
	DL_SASource[ ]
	alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]
	br=0[Main_Dispatch#], guess_branch
	br[DL_MESink#]

Main_Dispatch#:
	; ME (main) dispatch loop
	EthernetIngress[ ]
ingress_done#:
	alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]
	br=0[dl_start#]
	br!=byte[dl_next_block, 0, 1, DL_Drop#]

simple#:
	immed[dl_next_block, IX_EXCEPTION]
	.local ace_tag
	immed[ace_tag, SIMPLE_TAG]
	DL_SetAceTag[ace_tag]
	.endlocal

DL_SASink#:
	DL_SASink[ ]
	.continue

DL_MESink#:
	DL_MESink[ ]
	nop
	.continue

DL_Drop#:
	DL_Drop[ ]

.endw
nop
nop
nop
.endlocal
