#include <stdio.h>
#include <string.h>
#include <ix/asl.h>
#include "q.h"


struct 
{

  ix_buffer	items[BQ_LEN];
  int		bqh;
  int		bqt;
  ix_cond	hasdata;

} BQ[BQ_NUMP];

static ix_mutex qmutex;
static ix_cond someqhasdata;


static int firstwithdata();


ix_error initqueue()
{
int i;
ix_error e;

  memset(BQ, 0, sizeof(BQ));

  if ( (e = ix_mutex_new(&qmutex, IX_MUTEX_UNLOCKED)) )
    return e;

  if ( (e = ix_cond_new(&someqhasdata)) )
    return e;

  for ( i = 0 ; i < BQ_NUMP ; ++i )
    if ( (e = ix_cond_new(&BQ[i].hasdata)) )
      return e;

  return 0;
}



void enqueue(int q, ix_buffer ixb)
{
ix_error e;
int prev, bqh, bqt;

  if ( q < 0 || q >= BQ_NUMP )
    return;

  ix_mutex_lock(qmutex);

  bqh = BQ[q].bqh;
  bqt = BQ[q].bqt;

  prev = bqh ? bqh - 1 : BQ_LEN - 1;

  if ( bqt == prev )
  {
    ix_mutex_release(qmutex);
    fprintf(stderr, "Queue is full : deleting\n");
    if ( (e = ix_buffer_del(ixb)) )
    {
      fprintf(stderr, "Error deleting packet on full queue!\n");
      ix_error_dump(stderr,e);
      return;
    }
  }
  else
  {
    BQ[q].items[bqt] = ixb;
    BQ[q].bqt = (bqt + 1) % BQ_LEN;
    ix_cond_signal_one(someqhasdata);
    ix_cond_signal_one(BQ[q].hasdata);
  }

  ix_mutex_release(qmutex);
}


/* Must have mutex when calling this function */
static int
firstwithdata()
{
int i; 

  for ( i = 0 ; i < BQ_NUMP ; ++i )
    if ( BQ[i].bqh != BQ[i].bqt ) 
      break;

  if ( i == BQ_NUMP )
    return -1;
  else
    return i;
}


ix_buffer dequeue(int q)
{
ix_buffer ixb;
int i;

  if ( q > BQ_NUMP )
    return 0;

  ix_mutex_lock(qmutex);

  if ( q < 0 )
  {
    while (  (i = firstwithdata()) < 0 )
      ix_cond_wait(someqhasdata, qmutex);

    ixb = BQ[i].items[BQ[i].bqh];
    BQ[i].items[BQ[i].bqh] = BQ_NONE;
    BQ[i].bqh = (BQ[i].bqh + 1) % BQ_LEN;
  }
  else
  {
    while ( BQ[q].bqh == BQ[q].bqt )
      ix_cond_wait(BQ[q].hasdata, qmutex);

    ixb = BQ[q].items[BQ[q].bqh];
    BQ[q].items[BQ[q].bqh] = BQ_NONE;
    BQ[q].bqh = (BQ[q].bqh + 1) % BQ_LEN;
  }

  ix_mutex_release(qmutex);

  return ixb;
}



void finiqueue()
{
int i, j;
ix_error e;

  for ( i = 0 ; i < BQ_NUMP ; ++i )
  {

    for ( j = 0 ; j < BQ_LEN ; ++j )
    {

      if ( BQ[i].items[j] == BQ_NONE )
        continue;


      if ( (e = ix_buffer_del(BQ[i].items[j])) )
      {
        fprintf(stderr, "Error deleting packet on full queue!\n");
        ix_error_dump(stderr,e);
      }

    }


    if ( (e = ix_cond_del(BQ[i].hasdata)) )
    {
      fprintf(stderr, "Error deleting packet on full queue!\n");
      ix_error_dump(stderr,e);
    }

  }


  if ( (e = ix_mutex_del(qmutex)) )
  {
    fprintf(stderr, "Error deleting mutex!\n");
    ix_error_dump(stderr,e);
  }


  if ( (e = ix_cond_del(someqhasdata)) )
  {
    fprintf(stderr, "Error deleting condition variable!\n");
    ix_error_dump(stderr,e);
  }

}


int
isempty(int q)
{
int rv;

  if ( q < 0 || q > BQ_NUMP )
    return 0;

  ix_mutex_lock(qmutex);

  rv = BQ[q].bqh == BQ[q].bqt;

  ix_mutex_release(qmutex);

  return rv;
}
