#include <ix/asl.h>
#include <ix/ossl.h>
#include "SimpleAce.h"
#include "npapi.h"
#include "cat_net.h"
#include "netinc.h"
#include "cat_pack.h"
#include "q.h"

#define MAXCLI	32

ix_ossl_thread_t ServerThread;
ix_ace *thread_acep;

struct
{

  ix_ossl_thread_t	tid;
  int			inuse;
  int			fd;

} ThreadList[MAXCLI];

int WaitSocket;

ix_error apiServer(void *arg, void **ret);
ix_error serveClient(void *arg, void **ret);
int pack_fbuffer(char *db, ix_buffer ixb);
ix_buffer unpack_ixbuffer(int ifnum, int len, char *data);




ix_error
init_api_server(ix_ace *acep)
{
ix_error e;
int i;

  if ( (WaitSocket = cat_tcp_passive(0, NPAPISPORT_STR, 0)) < 0 )
  {
    fprintf(stderr, "SimpleAce :  Error creating socket!");
    return ix_error_new(IX_ERROR_LEVEL_GLOBAL, IX_ERROR_UNSPECIFIED, 0, 
                        "SimpleAce : Error creating passive socket.\n");
  }

  for ( i = 0 ; i < MAXCLI ; ++i )
    ThreadList[i].inuse = 0;

  if ( (e = ix_ossl_create_thread(&ServerThread, apiServer, (void *)0)) )
    return e;

  thread_acep = acep;

  return 0;
}




ix_error
apiServer(
   void *arg, void **ret)
{
int csock;
struct sockaddr_in sin;
int slen, i;
ix_error e;

  for ( ; ; ) 
  { 
    slen = sizeof(sin);
    if ( (csock = accept(WaitSocket, (struct sockaddr *)&sin, &slen)) < 0 )
    {
      fprintf(stderr, "SimpleAce:  Error accepting from socket!");
      ix_ossl_exit_thread(0, 0);
    }

    for ( i = 0 ; i < MAXCLI ; ++i )
      if ( !ThreadList[i].inuse )
        break;

    if ( i == MAXCLI )
    {
      unsigned char c = (unsigned char)-1;
      writen(csock, &c, sizeof(c));
      close(csock);
      continue;
    }

    ThreadList[i].inuse = 1;
    ThreadList[i].fd = csock;

    if ( (e = ix_ossl_create_thread(&ThreadList[i].tid,serveClient,(void *)i)) )
    {
      fprintf(stderr, "SimpleAce:  Error accepting from socket!");
      ix_ossl_exit_thread(0, 0);
    }
  } 

  return 0;
}



int
pack_ixbuffer(
   char *db,
   ix_buffer ixb)
{
char *fb;
ix_error e;
int ifnum, size, l;

  
  if ( (e = ix_buffer_get_ifnum(ixb, &ifnum)) )
  {
    fprintf(stderr, "Error getting interface for packet!\n");
    ix_error_dump(stderr, e);                                
    ix_buffer_del(ixb);
    return -1;
  }

  if ( (e = ix_buffer_get_size(ixb,&size)) )
  {
    fprintf(stderr, "Error getting size of packet!\n");
    ix_error_dump(stderr, e);                                
    ix_buffer_del(ixb);      
    return -1;          
  }

  if ( (e = ix_buffer_get_data(ixb, 0, size, &fb, &size)) )
  {
    fprintf(stderr, "Error getting size of packet!\n");
    ix_error_dump(stderr, e);                                
    ix_buffer_del(ixb);      
    return -1;          
  }
  
  l = cat_pack(db, "cww", 0, ifnum, size);
  memmove(db + l, fb, size);
  return l + size;
}



ix_buffer
unpack_ixbuffer(
   int ofnum, 
   int len, 
   char *data)
{
ix_buffer ixb;


  if ( ix_buffer_get(&ixb) )
    return 0;

  if ( len > MTU )
    return 0;

  if ( ix_buffer_put_data(ixb, data, len) )
  {
    ix_buffer_del(ixb);
    return 0;
  }

  if (ix_buffer_put_type(ixb, IX_HTYPE_ETHER) )
  {
    ix_buffer_del(ixb);
    return 0;
  }

  if ( ix_buffer_put_ofnum(ixb, ofnum) )
  {
    ix_buffer_del(ixb);
    return 0;
  }

  return ixb;
}



ix_error
serveClient(
   void *arg, void **ret)
{
int i, mynum = (int)arg, canread, ofnum, blen;
int fd = ThreadList[mynum].fd;
unsigned char c;
ix_buffer buf;
char db[4096];

  for ( ; ; ) 
  {
    i = sizeof(c);
    if ( readn(fd, &c, i) < i )
      goto quit;

    switch(c) 
    {

      case GET:
      {
        buf = dequeue(-1);
	if ( (i = pack_ixbuffer(db, buf)) < 0 )
          goto senderr;
	if ( writen(fd, db, i) < i )
	  goto quit;

        /* CHANGE:  error check? */
        ix_buffer_del(buf);
      }
      break;


      case GETFROM:
      {
        i = sizeof(c);
        if ( readn(fd, &c, i) < i )
          goto senderr;

        if ( c > BQ_NUMP )
	  goto senderr;

        buf = dequeue(c);

	if ( (i = pack_ixbuffer(db, buf)) < 0 )
          goto senderr;
	if ( writen(fd, db, i) < i )
	  goto quit;

        /* CHANGE:  error check? */
        ix_buffer_del(buf);
      }
      break;


      case CANREAD:
      {
        i = sizeof(c);
        if ( readn(fd, &c, i) < i )
          goto senderr;

	canread = !isempty(c);
        c = OK;

        i = sizeof(c);
	if ( writen(fd, &c, i) < i ) 
	  goto quit;
        
	c = (unsigned char)canread;
	if ( writen(fd, &c, i) < i ) 
	  goto quit;
      }
      break;


      case CANWRITE:
      {
        /* We have to get the port, but we don't use it */
        i = sizeof(c);
        if ( readn(fd, &c, i) < i )
          goto senderr;

        c = OK; 
        i = sizeof(c);
	if ( writen(fd, &c, i) < i ) 
	  goto quit;

        c = 1;
	if ( writen(fd, &c, i) < i ) 
	  goto quit;
      }
      break;


      case SEND:
      {
        i = 8;
	if ( readn(fd, db, i) < i )
	  goto senderr;

        cat_unpack(db, "ww", &ofnum, &blen);

        i = blen;
        if ( readn(fd, db, i) < i )
          goto senderr;

	if ( !(buf = unpack_ixbuffer(ofnum, blen, db)) )
          goto senderr;

        /* CHANGE :  DEBUG information */
        /* DumpPacket(buf); */

	if ( ix_target_take(&thread_acep->def_targ, buf) )
	  goto senderr;

        c = OK;
        i = sizeof(c);
	if ( writen(fd, &c, i) < i )
	  goto quit;
      }
      break;


      default:
	goto senderr;
    }
  }


senderr:
  c = (unsigned char)-1;
  writen(fd, &c, sizeof(c));

quit:
  close(fd);
  ThreadList[mynum].inuse = 0;
  return 0;
}




ix_error
fini_api_server()
{
ix_error e, e2;
void *ptr;
int i;

  for ( i = 0 ; i < MAXCLI ; ++i )
  {
    if ( !ThreadList[i].inuse )
      continue;

    if ( (e = ix_ossl_kill_thread(ThreadList[i].tid)) < 0 )
      return e;

    if ( (e = ix_ossl_wait_for_thread(ThreadList[i].tid, &e2, &ptr)) < 0 )
      return e;

    close(ThreadList[i].fd);
    ThreadList[i].inuse = 0;
  }

  if ( (e = ix_ossl_kill_thread(ServerThread)) < 0 )
    return e;

  if ( (e = ix_ossl_wait_for_thread(ServerThread, &e2, &ptr)) < 0 )
    return e;

  close(WaitSocket);
  
  return 0;
}
