/** INTEL CORPORATION PROPRIETARY INFORMATION
**      This software is supplied under the terms of a license agreement or
**      nondisclosure agreement with Intel Corporation and may not be copied
**      or disclosed except in accordance with the terms of that agreement.
**              Copyright (C) 2000 Intel Corporation. All rights Reserved.
*/

/*********************************************************************/

#include <stdlib.h>
#include <string.h>
#include "q.h"
#include "npapi.h"
#include "SimpleAce.h"

/*********************************************************************/

ix_error
ix_init(int argc, char **argv, ix_ace **acep)
{
SimpleAce *newAce;
ix_error e;


  /* Allocate an ace structure */
  if ( !(newAce = malloc(sizeof(*newAce))) )
    return ix_error_new(IX_ERROR_LEVEL_LOCAL,IX_ERROR_OOM,0,
                        "ix_init : couldn't allocate SimpleAce");


  /* Parse the options */
  newAce->meMask = atoi(argv[2]);
  strcpy(newAce->blockName, "SIMPLE");


  /* Initialize the ace */
  newAce->name[sizeof(newAce->name)-1] = '\0';
  strncpy(newAce->name, argv[1], sizeof(newAce->name)-1);
  if ( (e = ix_ace_init(newAce->base, newAce->name)) )
  {
    free(newAce);
    return ix_error_new(0, 0, e, "SimpleAce : Error in ix_ace_init()\n");
  }
  

  /* Initialize the microace portion */
  if ( (e = RmInit()) )
  {
    free(newAce);
    return ix_error_new(0, 0, e, "SimpleAce : Error in RmInit()\n");
  }


  e = RmRegister(&newAce->tag, newAce->blockName, newAce->base,
                 ExceptionHandler, newAce, newAce->meMask);
  if ( e ) 
  {
    free(newAce);
    return ix_error_new(0, 0, e, "SimpleAce : Error in RmRegister()\n");
  }


  if ( (e = initqueue()) ) 
  {
    free(newAce);
    return ix_error_new(0, 0, e, "SimpleAce : Error in initqueue()");
  }

  if ( (e = init_api_server(newAce->base)) ) 
  {
    free(newAce);
    return ix_error_new(0, 0, e, "SimpleAcec : Error in initqueue()");
  }

  /* Set the ace pointer */
    *acep = newAce->base;


  return 0;
}




ix_error ix_fini(int argc, char **argv, ix_ace *todestroy)
{
SimpleAce *ace = (SimpleAce *)todestroy;
ix_error e;
 

  /* MicroACE makes a call to unregister from the resource Manager */
  if ( (e = RmUnRegister(ace->tag)) )
    return ix_error_new(0, 0, e, "SimpleAce : Error in RmUnRegister()\n");

 
  /* Close communications with the resource mgr */
  if ( (e = RmTerm()) )
    return ix_error_new(0, 0, e, "SimpleAce : Error in RmTerm()\n");


  fini_api_server();


  finiqueue();


  if ( (e = ix_ace_fini(ace->base)) )
    return ix_error_new(0, 0, e, "SimpleAce : Error in ix_ace_fini()\n");


  return 0;
}
