#include "SimpleAce.h"
#include "q.h"


void RecievePacket(
   SimpleAce *sace,
   ix_buffer buf)
{
ix_error e;
int ifnum;

  /* Print the packet to output */
  /* This part is optional */
  /* DumpPacket(buf); */


  if ( (e = ix_buffer_get_ifnum(buf,&ifnum)) )
  {
    fprintf(stderr, "Error getting interface for packet!\n");
    ix_error_dump(stderr, e);
    ix_buffer_del(buf);
    return;
  }

  enqueue(ifnum, buf);
}




int
ix_action_default(
   ix_ace *acep, 
   ix_buffer buf)
{
SimpleAce *sace = (SimpleAce*) acep;

  RecievePacket(sace, buf);

  return RULE_DONE;
}




/*
 Intel Note:

 This function is called when you receive exception packets from the
 microengine
 
 THIS FUNCTION NEEDS TO RETURN an ix_error and not RULE_DONE. 

*/

int
ExceptionHandler(
   void *aux, 
   ix_ring ring, 
   ix_buffer buf)
{
SimpleAce *sace   = (SimpleAce*)  aux;
ix_error  e;
unsigned  char exceptionCode;


  /* Now get the exception code : THIS MUST MUST MUST BE DONE */
  if ( (e = RmGetExceptionCode(sace->tag, &exceptionCode)) )
  {
    fprintf(stderr, "%s:  Error getting exception code", sace->name);
    ix_error_dump(stderr, e);
    ix_buffer_del(buf);
    return e;
  }


  RecievePacket(sace, buf);

  return 0;
}

      



void 
DumpPacket(
   ix_buffer buf)
{
ix_error e;
size_t   size;
int      i, type, ifnum, iftype, rxstat, len;
ix_time  rxtime;
char     *ptr;


  fprintf(stderr, "Buffer handle is %x\n", buf);
  
  if ( (e = ix_buffer_get_size(buf,&size)) )
    goto error;

  if ( (e = ix_buffer_get_type(buf,&type)) )
    goto error;
  
  if ( (e = ix_buffer_get_ifnum(buf,&ifnum)) )
    goto error;

  if ( (e = ix_buffer_get_iftype(buf,&iftype)) )
    goto error;
  
  if ( (e = ix_buffer_get_rxstat(buf,&rxstat)) )
    goto error;

  if ( (e = ix_buffer_get_rxtime(buf,&rxtime)) )
    goto error;

  if ( (e = ix_buffer_get_data(buf,0,0,&ptr,&len)) )
    goto error;

  fprintf(stderr,
          "Packet: size %d, type 0x%x, ifnum 0x%x, iftype 0x%x, rxstat 0x%x\n",
          size, type, ifnum, iftype, rxstat);


  /* Now print the actual bytes */
  for (i = 0; i < len; i++)
  {
    fprintf(stderr,"%02x ",ptr[i]);
      
    if ( i % 20 == 19 )
       fprintf(stderr,"\n");
  }

  /* Polish up our line feeds */
  if ( len % 20 != 0 )
    fprintf(stderr, "\n");
  fprintf(stderr, "\n");

  return;


error:
  fprintf(stderr,"SimpleAce DumpPacket: error getting buffer attribute\n");
  ix_error_dump(stderr, e);
}
