#include "npapi.h"
#include "cat_pack.h"
#include <stdio.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <signal.h>

#define OURETHER	"\x00\x01\x02\x03\x04\x05"
#define OURIP		"\xac\x10\x00\x01"
#define NUMPORTS	4


int notdone = 1;


void termfunc(int i)
{ 
  fprintf(stderr, "Exiting...\n");
  np_stop();
  exit(0);
}


void error(char *str)
{ 
  fprintf(stderr, "%s", str); 
  exit(-1);
} 


void printPacket(struct fbuffer *fbuf)
{ 
char *p; 
int i, len;
unsigned short type;

  printf("New Packet on interface %d\n", fbuf->ifnum);
  printf("Length = %d\n", fbuf->len);

  len = fbuf->len;
  for ( i = 0; i < len ; ++i ) 
  { 
     printf("%02x ", fbuf->frame[i]);
     if ( i % 20 == 19 ) 
       printf("\n");
  }

  if ( i % 20 != 0 )
    printf("\n");
  printf("\n");
} 


int main()
{ 
char buffer[4096];
struct fbuffer *fbuf;
unsigned short type;
int i, rdy;

  signal(SIGTERM, termfunc);
  signal(SIGINT, termfunc);

  if ( np_start("127.0.0.1", "ifaceInput") )
    error("Couldn't get started\n");

  fbuf = (struct fbuffer *)buffer;

  for ( i = 0 ; i < NUMPORTS ; ++i ) 
  {
    rdy = iface_ready(i, INGRESS);
    if ( rdy )
      printf("Port %d has packets enqueued.\n", i);
    else
      printf("Port %d has no packets enqueued.\n", i);

    rdy = iface_ready(i, EGRESS);
    if ( rdy )
      printf("Port %d is ready to send.\n", i);
    else
      printf("Port %d is not ready to send.\n",i);
  }
 
  while ( 1 )
  {
    recv_frame(0, fbuf);
    printPacket(fbuf);

    /* First 14 bytes are : 
       0-5   : Destination Ethernet Address
       6-11  : Source Ethernet Address
       12-13 : The protocol of data stored in this packet (e.g. IP, ARP, ...)
     */

    type = ntohs(*(unsigned short *)(fbuf->frame + 12));

    if ( type == 0x0806 )  /* ARP packet */
    {
      unsigned char ip1[4], ha1[6];
      /* 14 == size of ethernet header */
      struct arphdr *arp = (struct arphdr *)(fbuf->frame + 14); 

      /* Route this packet out the appropriate outgoing interface */
      fbuf->ofnum = 0;

      /* Copy the source address into the destination address */
      memmove(fbuf->frame, fbuf->frame + 6, 6);

      arp->ar_op = htons(ARPOP_REPLY);
      memmove(ha1, (unsigned char *)(arp + 1), 6);
      memmove(ip1, (unsigned char *)(arp + 1)+6, 4);
      memmove((unsigned char *)(arp + 1), OURETHER, 6);
      memmove((unsigned char *)(arp + 1)+6, OURIP, 4);
      memmove((unsigned char *)(arp + 1)+10, ha1, 6);
      memmove((unsigned char *)(arp + 1)+16, ip1, 4);

      /* Fill in the ethernet source address on sending */
      send_frame(fbuf, 1);
      printf("Sent ");
      printPacket(fbuf);
    }
  }

  printf("Exiting\n");

  np_stop();

  return 0;
}
