#include <unistd.h>
#include <stdlib.h>
#include <ix/asl.h>
#include "npapi.h"
#include "cat_pack.h"
#include "cat_net.h"

static int Sock = -1;


/* CHANGE:  Assumes one type of address */
#define NUMPORTS	4
#define MACADDRLEN	6
#define SADDROFFSET	6

static char MacAddrs[NUMPORTS][MACADDRLEN];
static char *IName;

#define DBG	fprintf(stderr, "%s, %d\n", __FILE__, __LINE__);


int np_start(char *addr, char *iname)
{
int i;

  if ( ! addr )
    addr = "127.0.0.1";

  if ( (Sock = cat_tcp_connect(addr, NPAPISPORT_STR)) < 0 )
    return -1;

  IName = iname;
  for ( i = 0 ; i < NUMPORTS ; ++i ) 
  {
    if ( get_mac(iname, i, MacAddrs[i]) < 0 )
    {
      IName = 0;
      close(Sock);
      return -1;
    }

    if ( set_promisc(iname, i, 1) < 0 )
    {
      IName = 0;
      close(Sock);
      return -1;
    }
  }

  return 0;
}



void send_frame(struct fbuffer *fbuf, int safill)
{
ix_buffer ixbuf, newb;
char db[4096], *ap;
unsigned long len;
unsigned char c;

  if ( !fbuf )
  {
    fprintf(stderr, "Null frame buffer sent to send_frame\n");
    fprintf(stderr, "exiting...\n");
    exit(-1);
  }

  if ( fbuf->ofnum < 0 || fbuf->ofnum >= NUMPORTS )
  {
    fprintf(stderr, "Bad ofnum field in fbuffer for send_frame: \n",
            fbuf->ofnum);
    fprintf(stderr, "exiting...\n");
    exit(-1);
  }

  if ( safill ) 
  {
    ap = fbuf->frame + SADDROFFSET;
    memcpy(ap, MacAddrs[fbuf->ofnum], MACADDRLEN);
  }

  len = cat_pack(db, "cww", SEND, fbuf->ofnum, fbuf->len);
  memmove(db + len, fbuf->frame, fbuf->len);
  len += fbuf->len;

  if ( writen(Sock, db, len) < len )
    goto err;
  
  if ( (readn(Sock, &c, sizeof(c)) < sizeof(c)) || ( c == (unsigned char)-1) )
    goto err;

  return;

err:
  fprintf(stderr,"Internal error contacting network processor in send_frame\n");
  fprintf(stderr,"exiting....\n");
  exit(-1);
}



void recv_frame(int ifnum, struct fbuffer *fbuf)
{
ix_buffer ixbuf;
char db[512], c, *bp;
int len;

  if ( !fbuf )
  {
    fprintf(stderr, "Null frame buffer argument in recv_frame\n");
    fprintf(stderr, "exiting...\n");
    exit(-1);
  }

  db[0] = GETFROM;
  db[1] = (unsigned char)ifnum;

  if ( writen(Sock, &db, sizeof(db[0]) * 2 ) < sizeof(db[0]) )
    goto err;

  if ( ( readn(Sock, &c, sizeof(c)) < sizeof(c) ) || (c == (unsigned char)-1) )
    goto err;

  len = 8;
  if ( readn(Sock, db, len) < len )
    goto err;

  cat_unpack(db, "ww", &fbuf->ifnum, &fbuf->len);

  len = fbuf->len;
  if ( readn(Sock, fbuf->frame, len) < len )
    goto err;

  fbuf->ofnum = -1;

  return;

err:
  fprintf(stderr,"Internal error contacting network processor in recv_frame\n");
  fprintf(stderr,"exiting....\n");
  exit(-1);
}



void next_frame(struct fbuffer *fbuf)
{
ix_buffer ixbuf;
char db[512], c, *bp;
int len;

  if ( ! fbuf ) 
  {
    fprintf(stderr, "Null frame buffer argument in next_frame\n");
    fprintf(stderr, "exiting...\n");
    exit(-1);
  }

  c = GET;

  if ( writen(Sock, &c, sizeof(c) ) < sizeof(c) )
    goto err;

  if ( ( readn(Sock, &c, sizeof(c)) < sizeof(c) ) || (c == (unsigned char)-1) )
    goto err;

  len = 8;
  if ( readn(Sock, db, len) < len )
    goto err;

  cat_unpack(db, "ww", &fbuf->ifnum, &fbuf->len);

  len = fbuf->len;
  if ( readn(Sock, fbuf->frame, len) < len )
    goto err;

  fbuf->ofnum = -1;

  return;

err:
  fprintf(stderr,"Internal error contacting network processor in next_frame\n");
  fprintf(stderr,"exiting....\n");
  exit(-1);
}



int iface_ready(int ifnum, int direction)
{
unsigned char buf[2];

  if ( direction == INGRESS )
    buf[0] = CANREAD;
  else if ( direction == EGRESS )
    buf[0] = CANWRITE;
  else
  {
    fprintf(stderr, "illegal direction sent to iface_ready: %d\n", direction);
    fprintf(stderr, "exiting...\n");
    exit(-1);
  }

  buf[1] = ifnum;

  if ( writen(Sock, buf, sizeof(buf)) < sizeof(buf) )
    goto err;

  if ( ( readn(Sock, buf, sizeof(buf[0])) < sizeof(buf[0]) ) || 
       ( buf[0] == (unsigned char)-1 ) )
    goto err;

  if ( readn(Sock, buf, sizeof(buf[0])) < sizeof(buf[0]) )
    goto err;

  return buf[0];

err:
  fprintf(stderr,"Internal error contacting network processor in iface_ready"
          "\n");
  fprintf(stderr,"exiting....\n");
  exit(-1);
}



void np_stop()
{
int i;

  close(Sock);
  Sock = -1;

  for ( i = 0 ; i < NUMPORTS ; ++i ) 
    if ( set_promisc(IName, i, 0) < 0 )
    { 
      fprintf(stderr, "Internal error in np_stop()\n");
      fprintf(stderr, "exiting...\n");
      exit(-1);
    }

  IName = 0;
}



#undef offsetof
#define offsetof(type, field) ((int)(&(((type *)0)->field)))


struct fbuffer *new_fbuf(
   int flen)
{
int tlen;
struct fbuffer *fbuf;

  tlen = offsetof(struct fbuffer, frame) + flen;
  fbuf = malloc(tlen);
  if ( ! fbuf )
    return 0;

  fbuf->len = flen;
  fbuf->ifnum = -1;
  fbuf->ofnum = -1;

  return fbuf;
}
