/* -*- C -*- $Id$ */

/******  Code generated by the IX IDL Compiler *******
 * The IX IDL compiler has been developed by Intel Corp. in order
 * to work in conjunction with OMS communication infrastucture and
 * is based on freely available TAO IDL compiler developed by
 * the Center for Distributed Object Computing at
 * Washington University, St. Louis.
 *
 * Information about TAO IDL compiler is available at:
 *                 http://www.cs.wustl.edu/~schmidt/TAO.html
 */

#include <stdlib.h>

#include "ingress_ace_stub_c.h"
#include "ingress_ace_cb_c.h"

/**=================================================
 * Helper functions for tPortConfig_mac array 
 *================================================*/

/* Marshaling function for tPortConfig::mac array */
ix_error ix_sds_r_tPortConfig_mac (ix_sds aSds, const tPortConfig_mac_slice* val)
{
  static const char localFunctionName[] = "ix_sds_r_tPortConfig_mac";
  ix_error err = 0;
  
  int i;
  const unsigned char* pVal = (const unsigned char*) val;
  /**=================================================
   * Marshal each element of type unsigned char for the array 
   *================================================*/
  
  for (i = 0; i < 6; i++, pVal++)
  {
    err = ix_sds_r_octet(aSds, *pVal);
    if(err)
    {
      return ix_error_new(0, 0, err, 
        "%s - array element marshaling processing failed for unsigned char!", localFunctionName);
    };
  };
  
  return err;
}

/* Demarshaling function for tPortConfig::mac array */
ix_error ix_sds_p_tPortConfig_mac (ix_sds aSds, tPortConfig_mac_slice* val)
{
  static const char localFunctionName[] = "ix_sds_p_tPortConfig_mac";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the array 
   *================================================*/
  
  err = release_tPortConfig_mac(val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - array release failed!", localFunctionName);
  };
  
  {
    int i;
    unsigned char* pVal = (unsigned char*) val;
    /**=================================================
     * Demarshal each element of type unsigned char for the array 
     *================================================*/
    
    for (i = 0; i < 6; i++, pVal++)
    {
      err = ix_sds_p_octet(aSds, pVal);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - array element demarshaling processing failed for unsigned char!", localFunctionName);
      };
    };
    
  };
  return err;
}

/* Initialization function for tPortConfig::mac array */
ix_error init_tPortConfig_mac (tPortConfig_mac_slice* val)
{
  static const char localFunctionName[] = "init_tPortConfig_mac";
  ix_error err = 0;
  
  memset(val,0,sizeof(unsigned char) * 6);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Finalization function for tPortConfig::mac array */
ix_error fini_tPortConfig_mac (tPortConfig_mac_slice* val)
{
  static const char localFunctionName[] = "fini_tPortConfig_mac";
  ix_error err = 0;
  
  memset(val,0,sizeof(unsigned char) * 6);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Release function for tPortConfig::mac array */
ix_error release_tPortConfig_mac (tPortConfig_mac_slice* val)
{
  static const char localFunctionName[] = "release_tPortConfig_mac";
  ix_error err = 0;
  
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/**=================================================
 * End helper functions for tPortConfig_mac array 
 *================================================*/


/**=================================================
 * Helper functions for tPortConfig structure 
 *================================================*/

/* Marshaling function for tPortConfig structure */
ix_error ix_sds_r_tPortConfig (ix_sds aSds, const tPortConfig* val)
{
  static const char localFunctionName[] = "ix_sds_r_tPortConfig";
  ix_error err = 0;
  err = ix_sds_r_long(aSds, (val->portNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  err = ix_sds_r_long(aSds, (val->portType));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  err = ix_sds_r_long(aSds, (val->mtu));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  err = ix_sds_r_long(aSds, (val->cost));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  err = ix_sds_r_tPortConfig_mac(aSds, (val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for tPortConfig_mac!", localFunctionName);
  };
  err = ix_sds_r_long(aSds, (val->flags));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  if(err)
    return ix_error_new(0, 0, err, 
      "%s - error!", localFunctionName);
  return err;
}

/* Demarshaling function for tPortConfig structure */
ix_error ix_sds_p_tPortConfig (ix_sds aSds, tPortConfig* val)
{
  static const char localFunctionName[] = "ix_sds_p_tPortConfig";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the structure
   *================================================*/
  err = release_tPortConfig (val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure release failed for tPortConfig!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->portNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->portType));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->mtu));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->cost));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  err = ix_sds_p_tPortConfig_mac(aSds, (val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for tPortConfig_mac!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->flags));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  return err;
}

/* Initialization function for tPortConfig structure */
ix_error init_tPortConfig (tPortConfig* val)
{
  static const char localFunctionName[] = "init_tPortConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  memset(val, 0, sizeof(tPortConfig));
  err = init_tPortConfig_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member initialization failed for tPortConfig_mac!", localFunctionName);
  };
  return err;
}

/* Finalization function for tPortConfig structure */
ix_error fini_tPortConfig (tPortConfig* val)
{
  static const char localFunctionName[] = "fini_tPortConfig";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = fini_tPortConfig_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member finalization failed for tPortConfig_mac!", localFunctionName);
  };
  memset(val, 0, sizeof(tPortConfig));
  return err;
}

/* Release function for tPortConfig structure */
ix_error release_tPortConfig (tPortConfig* val)
{
  static const char localFunctionName[] = "release_tPortConfig";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = release_tPortConfig_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member release failed for tPortConfig_mac!", localFunctionName);
  };
  return err;
}


/**=================================================
 * Helper functions for tIfConfig_name array 
 *================================================*/

/* Marshaling function for tIfConfig::name array */
ix_error ix_sds_r_tIfConfig_name (ix_sds aSds, const tIfConfig_name_slice* val)
{
  static const char localFunctionName[] = "ix_sds_r_tIfConfig_name";
  ix_error err = 0;
  
  int i;
  const char* pVal = (const char*) val;
  /**=================================================
   * Marshal each element of type char for the array 
   *================================================*/
  
  for (i = 0; i < 128; i++, pVal++)
  {
    err = ix_sds_r_char(aSds, *pVal);
    if(err)
    {
      return ix_error_new(0, 0, err, 
        "%s - array element marshaling processing failed for char!", localFunctionName);
    };
  };
  
  return err;
}

/* Demarshaling function for tIfConfig::name array */
ix_error ix_sds_p_tIfConfig_name (ix_sds aSds, tIfConfig_name_slice* val)
{
  static const char localFunctionName[] = "ix_sds_p_tIfConfig_name";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the array 
   *================================================*/
  
  err = release_tIfConfig_name(val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - array release failed!", localFunctionName);
  };
  
  {
    int i;
    char* pVal = (char*) val;
    /**=================================================
     * Demarshal each element of type char for the array 
     *================================================*/
    
    for (i = 0; i < 128; i++, pVal++)
    {
      err = ix_sds_p_char(aSds, pVal);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - array element demarshaling processing failed for char!", localFunctionName);
      };
    };
    
  };
  return err;
}

/* Initialization function for tIfConfig::name array */
ix_error init_tIfConfig_name (tIfConfig_name_slice* val)
{
  static const char localFunctionName[] = "init_tIfConfig_name";
  ix_error err = 0;
  
  memset(val,0,sizeof(char) * 128);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Finalization function for tIfConfig::name array */
ix_error fini_tIfConfig_name (tIfConfig_name_slice* val)
{
  static const char localFunctionName[] = "fini_tIfConfig_name";
  ix_error err = 0;
  
  memset(val,0,sizeof(char) * 128);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Release function for tIfConfig::name array */
ix_error release_tIfConfig_name (tIfConfig_name_slice* val)
{
  static const char localFunctionName[] = "release_tIfConfig_name";
  ix_error err = 0;
  
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/**=================================================
 * End helper functions for tIfConfig_name array 
 *================================================*/


/**=================================================
 * Helper functions for tIfConfig structure 
 *================================================*/

/* Marshaling function for tIfConfig structure */
ix_error ix_sds_r_tIfConfig (ix_sds aSds, const tIfConfig* val)
{
  static const char localFunctionName[] = "ix_sds_r_tIfConfig";
  ix_error err = 0;
  err = ix_sds_r_long(aSds, (val->portNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->ifNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->ipV4Addr));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->ipV4Mask));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->flags));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_tIfConfig_name(aSds, (val->name));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for tIfConfig_name!", localFunctionName);
  };
  if(err)
    return ix_error_new(0, 0, err, 
      "%s - error!", localFunctionName);
  return err;
}

/* Demarshaling function for tIfConfig structure */
ix_error ix_sds_p_tIfConfig (ix_sds aSds, tIfConfig* val)
{
  static const char localFunctionName[] = "ix_sds_p_tIfConfig";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the structure
   *================================================*/
  err = release_tIfConfig (val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure release failed for tIfConfig!", localFunctionName);
  };
  err = ix_sds_p_long(aSds, &(val->portNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->ifNum));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->ipV4Addr));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->ipV4Mask));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->flags));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_tIfConfig_name(aSds, (val->name));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for tIfConfig_name!", localFunctionName);
  };
  return err;
}

/* Initialization function for tIfConfig structure */
ix_error init_tIfConfig (tIfConfig* val)
{
  static const char localFunctionName[] = "init_tIfConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  memset(val, 0, sizeof(tIfConfig));
  err = init_tIfConfig_name((val->name));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member initialization failed for tIfConfig_name!", localFunctionName);
  };
  return err;
}

/* Finalization function for tIfConfig structure */
ix_error fini_tIfConfig (tIfConfig* val)
{
  static const char localFunctionName[] = "fini_tIfConfig";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = fini_tIfConfig_name((val->name));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member finalization failed for tIfConfig_name!", localFunctionName);
  };
  memset(val, 0, sizeof(tIfConfig));
  return err;
}

/* Release function for tIfConfig structure */
ix_error release_tIfConfig (tIfConfig* val)
{
  static const char localFunctionName[] = "release_tIfConfig";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = release_tIfConfig_name((val->name));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member release failed for tIfConfig_name!", localFunctionName);
  };
  return err;
}


/**=================================================
 * Helper functions for tPortSnmpStats structure 
 *================================================*/

/* Marshaling function for tPortSnmpStats structure */
ix_error ix_sds_r_tPortSnmpStats (ix_sds aSds, const tPortSnmpStats* val)
{
  static const char localFunctionName[] = "ix_sds_r_tPortSnmpStats";
  ix_error err = 0;
  err = ix_sds_r_ulong(aSds, (val->rcvdFramesOk));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->sentFramesOk));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->rcvdBytes));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->sentBytes));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->sentMCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->rcvdMCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->sentBCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_r_ulong(aSds, (val->rcvdBCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for unsigned long!", localFunctionName);
  };
  if(err)
    return ix_error_new(0, 0, err, 
      "%s - error!", localFunctionName);
  return err;
}

/* Demarshaling function for tPortSnmpStats structure */
ix_error ix_sds_p_tPortSnmpStats (ix_sds aSds, tPortSnmpStats* val)
{
  static const char localFunctionName[] = "ix_sds_p_tPortSnmpStats";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the structure
   *================================================*/
  err = release_tPortSnmpStats (val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure release failed for tPortSnmpStats!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->rcvdFramesOk));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->sentFramesOk));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->rcvdBytes));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->sentBytes));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->sentMCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->rcvdMCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->sentBCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  err = ix_sds_p_ulong(aSds, &(val->rcvdBCastFrames));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for unsigned long!", localFunctionName);
  };
  return err;
}

/* Initialization function for tPortSnmpStats structure */
ix_error init_tPortSnmpStats (tPortSnmpStats* val)
{
  static const char localFunctionName[] = "init_tPortSnmpStats";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  memset(val, 0, sizeof(tPortSnmpStats));
  return err;
}

/* Finalization function for tPortSnmpStats structure */
ix_error fini_tPortSnmpStats (tPortSnmpStats* val)
{
  static const char localFunctionName[] = "fini_tPortSnmpStats";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  memset(val, 0, sizeof(tPortSnmpStats));
  return err;
}

/* Release function for tPortSnmpStats structure */
ix_error release_tPortSnmpStats (tPortSnmpStats* val)
{
  static const char localFunctionName[] = "release_tPortSnmpStats";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}


/**=================================================
 * Helper functions for tMacAddr_mac array 
 *================================================*/

/* Marshaling function for tMacAddr::mac array */
ix_error ix_sds_r_tMacAddr_mac (ix_sds aSds, const tMacAddr_mac_slice* val)
{
  static const char localFunctionName[] = "ix_sds_r_tMacAddr_mac";
  ix_error err = 0;
  
  int i;
  const unsigned char* pVal = (const unsigned char*) val;
  /**=================================================
   * Marshal each element of type unsigned char for the array 
   *================================================*/
  
  for (i = 0; i < 6; i++, pVal++)
  {
    err = ix_sds_r_octet(aSds, *pVal);
    if(err)
    {
      return ix_error_new(0, 0, err, 
        "%s - array element marshaling processing failed for unsigned char!", localFunctionName);
    };
  };
  
  return err;
}

/* Demarshaling function for tMacAddr::mac array */
ix_error ix_sds_p_tMacAddr_mac (ix_sds aSds, tMacAddr_mac_slice* val)
{
  static const char localFunctionName[] = "ix_sds_p_tMacAddr_mac";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the array 
   *================================================*/
  
  err = release_tMacAddr_mac(val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - array release failed!", localFunctionName);
  };
  
  {
    int i;
    unsigned char* pVal = (unsigned char*) val;
    /**=================================================
     * Demarshal each element of type unsigned char for the array 
     *================================================*/
    
    for (i = 0; i < 6; i++, pVal++)
    {
      err = ix_sds_p_octet(aSds, pVal);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - array element demarshaling processing failed for unsigned char!", localFunctionName);
      };
    };
    
  };
  return err;
}

/* Initialization function for tMacAddr::mac array */
ix_error init_tMacAddr_mac (tMacAddr_mac_slice* val)
{
  static const char localFunctionName[] = "init_tMacAddr_mac";
  ix_error err = 0;
  
  memset(val,0,sizeof(unsigned char) * 6);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Finalization function for tMacAddr::mac array */
ix_error fini_tMacAddr_mac (tMacAddr_mac_slice* val)
{
  static const char localFunctionName[] = "fini_tMacAddr_mac";
  ix_error err = 0;
  
  memset(val,0,sizeof(unsigned char) * 6);
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/* Release function for tMacAddr::mac array */
ix_error release_tMacAddr_mac (tMacAddr_mac_slice* val)
{
  static const char localFunctionName[] = "release_tMacAddr_mac";
  ix_error err = 0;
  
  
  (void)val;
  (void)localFunctionName;
  
  return err;
}

/**=================================================
 * End helper functions for tMacAddr_mac array 
 *================================================*/


/**=================================================
 * Helper functions for tMacAddr structure 
 *================================================*/

/* Marshaling function for tMacAddr structure */
ix_error ix_sds_r_tMacAddr (ix_sds aSds, const tMacAddr* val)
{
  static const char localFunctionName[] = "ix_sds_r_tMacAddr";
  ix_error err = 0;
  err = ix_sds_r_tMacAddr_mac(aSds, (val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member marshaling failed for tMacAddr_mac!", localFunctionName);
  };
  if(err)
    return ix_error_new(0, 0, err, 
      "%s - error!", localFunctionName);
  return err;
}

/* Demarshaling function for tMacAddr structure */
ix_error ix_sds_p_tMacAddr (ix_sds aSds, tMacAddr* val)
{
  static const char localFunctionName[] = "ix_sds_p_tMacAddr";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the structure
   *================================================*/
  err = release_tMacAddr (val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure release failed for tMacAddr!", localFunctionName);
  };
  err = ix_sds_p_tMacAddr_mac(aSds, (val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member demarshaling failed for tMacAddr_mac!", localFunctionName);
  };
  return err;
}

/* Initialization function for tMacAddr structure */
ix_error init_tMacAddr (tMacAddr* val)
{
  static const char localFunctionName[] = "init_tMacAddr";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  memset(val, 0, sizeof(tMacAddr));
  err = init_tMacAddr_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member initialization failed for tMacAddr_mac!", localFunctionName);
  };
  return err;
}

/* Finalization function for tMacAddr structure */
ix_error fini_tMacAddr (tMacAddr* val)
{
  static const char localFunctionName[] = "fini_tMacAddr";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = fini_tMacAddr_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member finalization failed for tMacAddr_mac!", localFunctionName);
  };
  memset(val, 0, sizeof(tMacAddr));
  return err;
}

/* Release function for tMacAddr structure */
ix_error release_tMacAddr (tMacAddr* val)
{
  static const char localFunctionName[] = "release_tMacAddr";
  ix_error err = 0;
  
  (void)val;
  (void)localFunctionName;
  
  err = release_tMacAddr_mac((val->mac));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - structure member release failed for tMacAddr_mac!", localFunctionName);
  };
  return err;
}


/**=================================================
 * Do not compile if this type have been defined before ixa_c_seq_tPortConfig sequence 
 *================================================*/

#ifndef _ixa_c_seq_tPortConfig_defined
#define _ixa_c_seq_tPortConfig_defined

/**=================================================
 * Helper functions for ixa_c_seq_tPortConfig sequence 
 *================================================*/

/* Marshaling function for tAPortConfig sequence */
ix_error ix_sds_r_ixa_c_seq_tPortConfig (ix_sds aSds, const ixa_c_seq_tPortConfig* val)
{
  static const char localFunctionName[] = "ix_sds_r_ixa_c_seq_tPortConfig";
  ix_error err = 0;
  tPortConfig* pBuffer;
  unsigned long aLength = 0;
  
  if(val->_length > val->_maximum)
    return ix_error_new(0, 0, err, 
      "%s - sequence length greater than maximum length!", localFunctionName);
    
  if(val->_buffer)
    aLength = val->_length;
  
  /**=================================================
   * Marshal the length of the sequence 
   *================================================*/
  
  err = ix_sds_r_ulong(aSds,aLength);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence length marshaling failed!", localFunctionName);
  };
  
  /**=================================================
   * marshaling each element of type tPortConfig for the sequence 
   *================================================*/
  
  for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_length; pBuffer++)
  {
    err = ix_sds_r_tPortConfig(aSds, pBuffer);
    if(err)
    {
      return ix_error_new(0, 0, err, 
        "%s - sequence element marshaling processing failed for tPortConfig!", localFunctionName);
    };
  };
  
  return err;
}

/* Demarshaling function for tAPortConfig sequence */
ix_error ix_sds_p_ixa_c_seq_tPortConfig (ix_sds aSds, ixa_c_seq_tPortConfig* val)
{
  static const char localFunctionName[] = "ix_sds_p_ixa_c_seq_tPortConfig";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the sequence 
   *================================================*/
  
  err = release_ixa_c_seq_tPortConfig(val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence release failed!", localFunctionName);
  };
  
  /**=================================================
   * Demarshal the length of the sequence 
   *================================================*/
  
  err = ix_sds_p_ulong(aSds,&(val->_length));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence length demarshaling failed!", localFunctionName);
  };
  
  /**=================================================
   * Check the space and reallocate as required 
   *================================================*/
  
  if(val->_length > val->_maximum)
  {
    tPortConfig* pBuffer;
    (void)pBuffer;
    
    if(val->_release && val->_buffer)
      free(val->_buffer);
    val->_maximum = val->_length;
    val->_buffer = malloc(sizeof(tPortConfig) * val->_maximum);
    if(val->_buffer == 0)
      return ix_error_new(0, 0, err, 
        "%s - memory buffer allocation failed for ixa_c_seq_tPortConfig sequence!", localFunctionName);
    
    
    /**=================================================
     * Initialize each element of type tPortConfig for the sequence
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
    {
      err = init_tPortConfig(pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element initializing failed for tPortConfig!", localFunctionName);
      };
    };
    
  };
  if(val->_buffer)
  {
    tPortConfig* pBuffer;
    
    /**=================================================
     * demarshaling each element of type tPortConfig for the sequence 
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_length; pBuffer++)
    {
      err = ix_sds_p_tPortConfig(aSds, pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element demarshaling processing failed for tPortConfig!", localFunctionName);
      };
    };
    
  };
  return err;
}

/* Initialization function for tAPortConfig sequence */
ix_error init_ixa_c_seq_tPortConfig (ixa_c_seq_tPortConfig* val)
{
  static const char localFunctionName[] = "init_ixa_c_seq_tPortConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  val->_maximum = 0;
  val->_length = 0;
  val->_release = 1;
  
  val->_buffer = 0;
  
  return err;
}

/* Finalization function for tAPortConfig sequence */
ix_error fini_ixa_c_seq_tPortConfig (ixa_c_seq_tPortConfig* val)
{
  static const char localFunctionName[] = "fini_ixa_c_seq_tPortConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  if(val->_release)
  {
    if(val->_buffer)
    {
      tPortConfig* pBuffer;
      
      /**=================================================
       * Finalize each element of type tPortConfig for the sequence 
       *================================================*/
      
      for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
      {
        err = fini_tPortConfig(pBuffer);
        if(err)
        {
          return ix_error_new(0, 0, err, 
            "%s - sequence element finalization failed for tPortConfig!", localFunctionName);
        };
      };
      
      free(val->_buffer);
      val->_buffer = 0;
    };
    val->_maximum = 0;
    val->_length = 0;
  };
  return err;
}

/* Release function for tAPortConfig sequence */
ix_error release_ixa_c_seq_tPortConfig (ixa_c_seq_tPortConfig* val)
{
  static const char localFunctionName[] = "release_ixa_c_seq_tPortConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  if(val->_release && val->_buffer)
  {
    tPortConfig* pBuffer;
    
    /**=================================================
     * Release each element of type tPortConfig for the sequence 
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
    {
      err = release_tPortConfig(pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element release failed for tPortConfig!", localFunctionName);
      };
    };
    
  };
  return err;
}

/**=================================================
 * End helper functions for ixa_c_seq_tPortConfig sequence 
 *================================================*/

#endif  /* end define _ixa_c_seq_tPortConfig_defined */


/**=================================================
 * Do not compile if this type have been defined before ixa_c_seq_tIfConfig sequence 
 *================================================*/

#ifndef _ixa_c_seq_tIfConfig_defined
#define _ixa_c_seq_tIfConfig_defined

/**=================================================
 * Helper functions for ixa_c_seq_tIfConfig sequence 
 *================================================*/

/* Marshaling function for tAIfConfig sequence */
ix_error ix_sds_r_ixa_c_seq_tIfConfig (ix_sds aSds, const ixa_c_seq_tIfConfig* val)
{
  static const char localFunctionName[] = "ix_sds_r_ixa_c_seq_tIfConfig";
  ix_error err = 0;
  tIfConfig* pBuffer;
  unsigned long aLength = 0;
  
  if(val->_length > val->_maximum)
    return ix_error_new(0, 0, err, 
      "%s - sequence length greater than maximum length!", localFunctionName);
    
  if(val->_buffer)
    aLength = val->_length;
  
  /**=================================================
   * Marshal the length of the sequence 
   *================================================*/
  
  err = ix_sds_r_ulong(aSds,aLength);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence length marshaling failed!", localFunctionName);
  };
  
  /**=================================================
   * marshaling each element of type tIfConfig for the sequence 
   *================================================*/
  
  for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_length; pBuffer++)
  {
    err = ix_sds_r_tIfConfig(aSds, pBuffer);
    if(err)
    {
      return ix_error_new(0, 0, err, 
        "%s - sequence element marshaling processing failed for tIfConfig!", localFunctionName);
    };
  };
  
  return err;
}

/* Demarshaling function for tAIfConfig sequence */
ix_error ix_sds_p_ixa_c_seq_tIfConfig (ix_sds aSds, ixa_c_seq_tIfConfig* val)
{
  static const char localFunctionName[] = "ix_sds_p_ixa_c_seq_tIfConfig";
  ix_error err = 0;
  
  /**=================================================
   * Release the resources of the sequence 
   *================================================*/
  
  err = release_ixa_c_seq_tIfConfig(val);
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence release failed!", localFunctionName);
  };
  
  /**=================================================
   * Demarshal the length of the sequence 
   *================================================*/
  
  err = ix_sds_p_ulong(aSds,&(val->_length));
  if(err)
  {
    return ix_error_new(0, 0, err, 
      "%s - sequence length demarshaling failed!", localFunctionName);
  };
  
  /**=================================================
   * Check the space and reallocate as required 
   *================================================*/
  
  if(val->_length > val->_maximum)
  {
    tIfConfig* pBuffer;
    (void)pBuffer;
    
    if(val->_release && val->_buffer)
      free(val->_buffer);
    val->_maximum = val->_length;
    val->_buffer = malloc(sizeof(tIfConfig) * val->_maximum);
    if(val->_buffer == 0)
      return ix_error_new(0, 0, err, 
        "%s - memory buffer allocation failed for ixa_c_seq_tIfConfig sequence!", localFunctionName);
    
    
    /**=================================================
     * Initialize each element of type tIfConfig for the sequence
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
    {
      err = init_tIfConfig(pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element initializing failed for tIfConfig!", localFunctionName);
      };
    };
    
  };
  if(val->_buffer)
  {
    tIfConfig* pBuffer;
    
    /**=================================================
     * demarshaling each element of type tIfConfig for the sequence 
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_length; pBuffer++)
    {
      err = ix_sds_p_tIfConfig(aSds, pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element demarshaling processing failed for tIfConfig!", localFunctionName);
      };
    };
    
  };
  return err;
}

/* Initialization function for tAIfConfig sequence */
ix_error init_ixa_c_seq_tIfConfig (ixa_c_seq_tIfConfig* val)
{
  static const char localFunctionName[] = "init_ixa_c_seq_tIfConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  val->_maximum = 0;
  val->_length = 0;
  val->_release = 1;
  
  val->_buffer = 0;
  
  return err;
}

/* Finalization function for tAIfConfig sequence */
ix_error fini_ixa_c_seq_tIfConfig (ixa_c_seq_tIfConfig* val)
{
  static const char localFunctionName[] = "fini_ixa_c_seq_tIfConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  if(val->_release)
  {
    if(val->_buffer)
    {
      tIfConfig* pBuffer;
      
      /**=================================================
       * Finalize each element of type tIfConfig for the sequence 
       *================================================*/
      
      for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
      {
        err = fini_tIfConfig(pBuffer);
        if(err)
        {
          return ix_error_new(0, 0, err, 
            "%s - sequence element finalization failed for tIfConfig!", localFunctionName);
        };
      };
      
      free(val->_buffer);
      val->_buffer = 0;
    };
    val->_maximum = 0;
    val->_length = 0;
  };
  return err;
}

/* Release function for tAIfConfig sequence */
ix_error release_ixa_c_seq_tIfConfig (ixa_c_seq_tIfConfig* val)
{
  static const char localFunctionName[] = "release_ixa_c_seq_tIfConfig";
  ix_error err = 0;
  
  (void)localFunctionName;
  
  if(val->_release && val->_buffer)
  {
    tIfConfig* pBuffer;
    
    /**=================================================
     * Release each element of type tIfConfig for the sequence 
     *================================================*/
    
    for(pBuffer = val->_buffer; pBuffer < val->_buffer + val->_maximum; pBuffer++)
    {
      err = release_tIfConfig(pBuffer);
      if(err)
      {
        return ix_error_new(0, 0, err, 
          "%s - sequence element release failed for tIfConfig!", localFunctionName);
      };
    };
    
  };
  return err;
}

/**=================================================
 * End helper functions for ixa_c_seq_tIfConfig sequence 
 *================================================*/

#endif  /* end define _ixa_c_seq_tIfConfig_defined */



/**=================================================
 * Start stub definition of interface portMgmt
 *================================================*/


/* Declare the interface name for portMgmt interface */
const char portMgmt_intName[] = "portMgmt";

/* Define the local operation names for CC_VMT_portMgmt interface */

/* Define the name for portMgmt::portGetPorts operation */
const char portMgmt_portGetPorts_opName[] = "portMgmt_portGetPorts";

/* Define the name for portMgmt::portGetConfig operation */
const char portMgmt_portGetConfig_opName[] = "portMgmt_portGetConfig";

/* Define the name for portMgmt::portSetConfig operation */
const char portMgmt_portSetConfig_opName[] = "portMgmt_portSetConfig";

/* Define the name for portMgmt::portEnable operation */
const char portMgmt_portEnable_opName[] = "portMgmt_portEnable";

/* Define the name for portMgmt::portDisable operation */
const char portMgmt_portDisable_opName[] = "portMgmt_portDisable";

/* Define the name for portMgmt::portGetFlags operation */
const char portMgmt_portGetFlags_opName[] = "portMgmt_portGetFlags";

/* Define the name for portMgmt::portSetFlags operation */
const char portMgmt_portSetFlags_opName[] = "portMgmt_portSetFlags";

/* Define the name for portMgmt::portAddMacAddrFilter operation */
const char portMgmt_portAddMacAddrFilter_opName[] = "portMgmt_portAddMacAddrFilter";

/* Define the name for portMgmt::portRemoveMacAddrFilter operation */
const char portMgmt_portRemoveMacAddrFilter_opName[] = "portMgmt_portRemoveMacAddrFilter";

/* Define the name for portMgmt::portSetMacAddr operation */
const char portMgmt_portSetMacAddr_opName[] = "portMgmt_portSetMacAddr";

/* Define the name for portMgmt::portGetMacAddr operation */
const char portMgmt_portGetMacAddr_opName[] = "portMgmt_portGetMacAddr";

/* Define the name for portMgmt::portSetPromiscMode operation */
const char portMgmt_portSetPromiscMode_opName[] = "portMgmt_portSetPromiscMode";

/* Define the name for portMgmt::portClearPromiscMode operation */
const char portMgmt_portClearPromiscMode_opName[] = "portMgmt_portClearPromiscMode";

/* Define the name for portMgmt::portClearStats operation */
const char portMgmt_portClearStats_opName[] = "portMgmt_portClearStats";

/* Define the name for portMgmt::portGetSnmpStats operation */
const char portMgmt_portGetSnmpStats_opName[] = "portMgmt_portGetSnmpStats";


/**=================================================
 * Stub initializer for interface portMgmt
 *================================================*/
ix_error stub_portMgmt_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "stub_portMgmt_init";
  /* static const char* localInterfaceName = portMgmt_intName; */
  
  ix_error err = 0;
  VMT_CrossCallEntry aVMTCCEntry = {0,0,0};
  VMT_CrossCallEntry* pVMTCCEntry;
  VMT_CrossCallRefEntry* pVMTCCREntry;
  VMT_CallBackEntry* pVMTCBEntry;
  CB_VMT_portMgmt* pCBVMT;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  basep->m_pCap = capp;
  basep->connected = 0;
  basep->connecterror = 0;
  basep->ns = 0;
  basep->ccname = 0;
  basep->user_connect_cb = 0;
  basep->cb_ctx = 0;
  basep->connectmutex = 0;
  
  if(sizeof(basep->m_pCommDesc.guid) <= strlen(portMgmt_intName))
  {
    strncpy(basep->m_pCommDesc.guid, portMgmt_intName, sizeof(basep->m_pCommDesc.guid) - 1);
    printf("Warning!\n\tThe GUID size is larger than the allocated space for the GUID\n\tin the communication descriptor structure!\n\tThe GUID has been trucated to %d characters!\n", sizeof(basep->m_pCommDesc.guid) - 1);
  }
  else
    strcpy(basep->m_pCommDesc.guid, portMgmt_intName);
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_portMgmt)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  pVMTCCREntry = (VMT_CrossCallRefEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallRefEntry));
  if(pVMTCCREntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall reference VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallRefTable = pVMTCCREntry;
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = portMgmt_portGetPorts_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetConfig_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetConfig_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portEnable_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portDisable_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetFlags_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetFlags_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portAddMacAddrFilter_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portRemoveMacAddrFilter_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetMacAddr_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetMacAddr_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetPromiscMode_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portClearPromiscMode_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portClearStats_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetSnmpStats_opName;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  /* Intialize the crosscall reference table entries */
  
  aVMTCCEntry._vName = portMgmt_portGetPorts_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portGetPorts;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portGetConfig_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portGetConfig;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portSetConfig_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portSetConfig;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portEnable_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portEnable;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portDisable_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portDisable;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portGetFlags_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portGetFlags;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portSetFlags_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portSetFlags;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portAddMacAddrFilter_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portAddMacAddrFilter;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portRemoveMacAddrFilter_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portRemoveMacAddrFilter;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portSetMacAddr_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portSetMacAddr;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portGetMacAddr_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portGetMacAddr;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portSetPromiscMode_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portSetPromiscMode;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portClearPromiscMode_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portClearPromiscMode;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portClearStats_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portClearStats;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = portMgmt_portGetSnmpStats_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_portMgmt_portGetSnmpStats;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallRefTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallRefEntry), cross_call_ref_entry_predicate);
  
  
  pCBVMT = (CB_VMT_portMgmt*) malloc(sizeof(CB_VMT_portMgmt));
  if(pCBVMT == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback VMT allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the callback VMT */
  
  basep->_pVMTCallBack = pCBVMT;
  
  pCBVMT->_pCB_portMgmt_portGetPorts = portMgmt_portGetPorts_cb;
  pCBVMT->_pCB_portMgmt_portGetConfig = portMgmt_portGetConfig_cb;
  pCBVMT->_pCB_portMgmt_portGetFlags = portMgmt_portGetFlags_cb;
  pCBVMT->_pCB_portMgmt_portGetMacAddr = portMgmt_portGetMacAddr_cb;
  pCBVMT->_pCB_portMgmt_portGetSnmpStats = portMgmt_portGetSnmpStats_cb;
  /* callback table initialization */
  basep->_vVMTCallBackSize = sizeof(CB_VMT_portMgmt)/sizeof(idl_ixa_c_CallBack_fptr);
  pVMTCBEntry = (VMT_CallBackEntry*) malloc(basep->_vVMTCallBackSize * sizeof(VMT_CallBackEntry));
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the callback VMT table entries */
  
  basep->_pVMTCallBackTable = pVMTCBEntry;
  
  pVMTCBEntry->_vName = portMgmt_portGetPorts_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_portMgmt_portGetPorts;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_portMgmt_portGetPorts;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = portMgmt_portGetConfig_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_portMgmt_portGetConfig;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_portMgmt_portGetConfig;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = portMgmt_portGetFlags_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_portMgmt_portGetFlags;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_portMgmt_portGetFlags;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = portMgmt_portGetMacAddr_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_portMgmt_portGetMacAddr;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_portMgmt_portGetMacAddr;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = portMgmt_portGetSnmpStats_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_portMgmt_portGetSnmpStats;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_portMgmt_portGetSnmpStats;
  pVMTCBEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  
  basep->_vTokenType = IDL_IXA_C_CLIENT;
  basep->_pInterfaceName = portMgmt_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCallBackTable != 0)
      free(basep->_pVMTCallBackTable);
    if(basep->_pVMTCallBack != 0)
      free(basep->_pVMTCallBack);
    basep->_vVMTCallBackSize = 0;
    
    if(basep->_pVMTCrossCallRefTable != 0)
      free(basep->_pVMTCrossCallRefTable);
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    
  };
  return err;
}

/**=================================================
 * Stub finalizer for interface portMgmt
 *================================================*/
ix_error stub_portMgmt_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "stub_portMgmt_fini";
  static const char* localInterfaceName = portMgmt_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_CLIENT)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of CLIENT type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCallBackTable);
  free(basep->_pVMTCallBack);
  basep->_vVMTCallBackSize = 0;
  
  free(basep->_pVMTCrossCallRefTable);
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/* Accessor function for callback VMT */
ix_error getCBVMT_portMgmt(const ix_base_t* basep, CB_VMT_portMgmt** pInterfaceCBVMT)
{
  static const char localFunctionName[] = "CB_VMT_portMgmt";
  static const char* localInterfaceName = portMgmt_intName;
  
  ix_error err = 0;
  
  *pInterfaceCBVMT = 0;
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_CLIENT)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of CLIENT type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  
  *pInterfaceCBVMT = (CB_VMT_portMgmt*) basep->_pVMTCallBack;
  
err_label1:
  return err;
}

/**=================================================
 * Define the interface operations
 *================================================*/
ix_error stub_portMgmt_portGetPorts(ix_base_t* basep)
{
  static const char localFunctionName[] = "stub_portMgmt_portGetPorts";
  static const char* localOperationName = portMgmt_portGetPorts_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portGetPorts);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_portMgmt_portGetPorts;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for portMgmt::portGetPorts deffered operation
 *================================================*/
ix_error deferred_cb_portMgmt_portGetPorts(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_portMgmt_portGetPorts";
  static const char* localOperationName = portMgmt_portGetPorts_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_portMgmt_portGetPorts, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tAPortConfig ports;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_ixa_c_seq_tPortConfig(&ports);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - sequence initialization failed for tAPortConfig!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_ixa_c_seq_tPortConfig(aSds, &ports);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ports!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((portMgmt_portGetPorts_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &ports);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback portMgmt_portGetPorts_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_ixa_c_seq_tPortConfig(&ports);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - sequence finalization failed for tAPortConfig!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portGetConfig(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portGetConfig";
  static const char* localOperationName = portMgmt_portGetConfig_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portGetConfig);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_portMgmt_portGetConfig;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for portMgmt::portGetConfig deffered operation
 *================================================*/
ix_error deferred_cb_portMgmt_portGetConfig(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_portMgmt_portGetConfig";
  static const char* localOperationName = portMgmt_portGetConfig_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_portMgmt_portGetConfig, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tPortConfig portConfig;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_tPortConfig(&portConfig);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - structure initialization failed for tPortConfig!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_tPortConfig(aSds, &portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portConfig!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((portMgmt_portGetConfig_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &portConfig);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback portMgmt_portGetConfig_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_tPortConfig(&portConfig);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - structure finalization failed for tPortConfig!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portSetConfig(ix_base_t* basep, long portNum, const tPortConfig* portConfig)
{
  static const char localFunctionName[] = "stub_portMgmt_portSetConfig";
  static const char* localOperationName = portMgmt_portSetConfig_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portSetConfig);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_tPortConfig(aSds, portConfig);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portConfig!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portEnable(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portEnable";
  static const char* localOperationName = portMgmt_portEnable_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portEnable);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portDisable(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portDisable";
  static const char* localOperationName = portMgmt_portDisable_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portDisable);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portGetFlags(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portGetFlags";
  static const char* localOperationName = portMgmt_portGetFlags_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portGetFlags);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_portMgmt_portGetFlags;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for portMgmt::portGetFlags deffered operation
 *================================================*/
ix_error deferred_cb_portMgmt_portGetFlags(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_portMgmt_portGetFlags";
  static const char* localOperationName = portMgmt_portGetFlags_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_portMgmt_portGetFlags, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  unsigned long flags;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_ulong(aSds, &flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((portMgmt_portGetFlags_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, flags);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback portMgmt_portGetFlags_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portSetFlags(ix_base_t* basep, long portNum, unsigned long flags)
{
  static const char localFunctionName[] = "stub_portMgmt_portSetFlags";
  static const char* localOperationName = portMgmt_portSetFlags_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portSetFlags);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, flags);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for flags!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portAddMacAddrFilter(ix_base_t* basep, long portNum, const tMacAddr* addr)
{
  static const char localFunctionName[] = "stub_portMgmt_portAddMacAddrFilter";
  static const char* localOperationName = portMgmt_portAddMacAddrFilter_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portAddMacAddrFilter);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_tMacAddr(aSds, addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for addr!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portRemoveMacAddrFilter(ix_base_t* basep, long portNum, const tMacAddr* addr)
{
  static const char localFunctionName[] = "stub_portMgmt_portRemoveMacAddrFilter";
  static const char* localOperationName = portMgmt_portRemoveMacAddrFilter_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portRemoveMacAddrFilter);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_tMacAddr(aSds, addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for addr!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portSetMacAddr(ix_base_t* basep, long portNum, const tMacAddr* addr)
{
  static const char localFunctionName[] = "stub_portMgmt_portSetMacAddr";
  static const char* localOperationName = portMgmt_portSetMacAddr_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portSetMacAddr);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_tMacAddr(aSds, addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for addr!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portGetMacAddr(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portGetMacAddr";
  static const char* localOperationName = portMgmt_portGetMacAddr_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portGetMacAddr);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_portMgmt_portGetMacAddr;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for portMgmt::portGetMacAddr deffered operation
 *================================================*/
ix_error deferred_cb_portMgmt_portGetMacAddr(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_portMgmt_portGetMacAddr";
  static const char* localOperationName = portMgmt_portGetMacAddr_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_portMgmt_portGetMacAddr, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tMacAddr addr;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_tMacAddr(&addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - structure initialization failed for tMacAddr!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_tMacAddr(aSds, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for addr!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((portMgmt_portGetMacAddr_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback portMgmt_portGetMacAddr_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_tMacAddr(&addr);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - structure finalization failed for tMacAddr!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portSetPromiscMode(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portSetPromiscMode";
  static const char* localOperationName = portMgmt_portSetPromiscMode_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portSetPromiscMode);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portClearPromiscMode(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portClearPromiscMode";
  static const char* localOperationName = portMgmt_portClearPromiscMode_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portClearPromiscMode);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portClearStats(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portClearStats";
  static const char* localOperationName = portMgmt_portClearStats_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portClearStats);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_portMgmt_portGetSnmpStats(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_portMgmt_portGetSnmpStats";
  static const char* localOperationName = portMgmt_portGetSnmpStats_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_portMgmt_portGetSnmpStats);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_portMgmt_portGetSnmpStats;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for portMgmt::portGetSnmpStats deffered operation
 *================================================*/
ix_error deferred_cb_portMgmt_portGetSnmpStats(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_portMgmt_portGetSnmpStats";
  static const char* localOperationName = portMgmt_portGetSnmpStats_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_portMgmt_portGetSnmpStats, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tPortSnmpStats stats;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_tPortSnmpStats(&stats);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - structure initialization failed for tPortSnmpStats!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_tPortSnmpStats(aSds, &stats);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for stats!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((portMgmt_portGetSnmpStats_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &stats);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback portMgmt_portGetSnmpStats_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_tPortSnmpStats(&stats);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - structure finalization failed for tPortSnmpStats!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}



/**=================================================
 * End stub definition of interface portMgmt
 *================================================*/



/**=================================================
 * Start stub definition of interface logicalIfMgmt
 *================================================*/


/* Declare the interface name for logicalIfMgmt interface */
const char logicalIfMgmt_intName[] = "logicalIfMgmt";

/* Define the local operation names for CC_VMT_logicalIfMgmt interface */

/* Define the name for logicalIfMgmt::ifGetIfs operation */
const char logicalIfMgmt_ifGetIfs_opName[] = "logicalIfMgmt_ifGetIfs";

/* Define the name for logicalIfMgmt::ifGetConfig operation */
const char logicalIfMgmt_ifGetConfig_opName[] = "logicalIfMgmt_ifGetConfig";

/* Define the name for logicalIfMgmt::ifSetConfig operation */
const char logicalIfMgmt_ifSetConfig_opName[] = "logicalIfMgmt_ifSetConfig";

/* Define the name for logicalIfMgmt::ifSetFlags operation */
const char logicalIfMgmt_ifSetFlags_opName[] = "logicalIfMgmt_ifSetFlags";

/* Define the name for logicalIfMgmt::ifGetFlags operation */
const char logicalIfMgmt_ifGetFlags_opName[] = "logicalIfMgmt_ifGetFlags";

/* Define the name for logicalIfMgmt::ifAddIf operation */
const char logicalIfMgmt_ifAddIf_opName[] = "logicalIfMgmt_ifAddIf";

/* Define the name for logicalIfMgmt::ifRemoveIf operation */
const char logicalIfMgmt_ifRemoveIf_opName[] = "logicalIfMgmt_ifRemoveIf";


/**=================================================
 * Stub initializer for interface logicalIfMgmt
 *================================================*/
ix_error stub_logicalIfMgmt_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_init";
  /* static const char* localInterfaceName = logicalIfMgmt_intName; */
  
  ix_error err = 0;
  VMT_CrossCallEntry aVMTCCEntry = {0,0,0};
  VMT_CrossCallEntry* pVMTCCEntry;
  VMT_CrossCallRefEntry* pVMTCCREntry;
  VMT_CallBackEntry* pVMTCBEntry;
  CB_VMT_logicalIfMgmt* pCBVMT;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  basep->m_pCap = capp;
  basep->connected = 0;
  basep->connecterror = 0;
  basep->ns = 0;
  basep->ccname = 0;
  basep->user_connect_cb = 0;
  basep->cb_ctx = 0;
  basep->connectmutex = 0;
  
  if(sizeof(basep->m_pCommDesc.guid) <= strlen(logicalIfMgmt_intName))
  {
    strncpy(basep->m_pCommDesc.guid, logicalIfMgmt_intName, sizeof(basep->m_pCommDesc.guid) - 1);
    printf("Warning!\n\tThe GUID size is larger than the allocated space for the GUID\n\tin the communication descriptor structure!\n\tThe GUID has been trucated to %d characters!\n", sizeof(basep->m_pCommDesc.guid) - 1);
  }
  else
    strcpy(basep->m_pCommDesc.guid, logicalIfMgmt_intName);
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_logicalIfMgmt)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  pVMTCCREntry = (VMT_CrossCallRefEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallRefEntry));
  if(pVMTCCREntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall reference VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallRefTable = pVMTCCREntry;
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetIfs_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetConfig_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifSetConfig_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifSetFlags_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetFlags_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifAddIf_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifRemoveIf_opName;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  /* Intialize the crosscall reference table entries */
  
  aVMTCCEntry._vName = logicalIfMgmt_ifGetIfs_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifGetIfs;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifGetConfig_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifGetConfig;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifSetConfig_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifSetConfig;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifSetFlags_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifSetFlags;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifGetFlags_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifGetFlags;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifAddIf_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifAddIf;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = logicalIfMgmt_ifRemoveIf_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_logicalIfMgmt_ifRemoveIf;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallRefTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallRefEntry), cross_call_ref_entry_predicate);
  
  
  pCBVMT = (CB_VMT_logicalIfMgmt*) malloc(sizeof(CB_VMT_logicalIfMgmt));
  if(pCBVMT == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback VMT allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the callback VMT */
  
  basep->_pVMTCallBack = pCBVMT;
  
  pCBVMT->_pCB_logicalIfMgmt_ifGetIfs = logicalIfMgmt_ifGetIfs_cb;
  pCBVMT->_pCB_logicalIfMgmt_ifGetConfig = logicalIfMgmt_ifGetConfig_cb;
  pCBVMT->_pCB_logicalIfMgmt_ifGetFlags = logicalIfMgmt_ifGetFlags_cb;
  /* callback table initialization */
  basep->_vVMTCallBackSize = sizeof(CB_VMT_logicalIfMgmt)/sizeof(idl_ixa_c_CallBack_fptr);
  pVMTCBEntry = (VMT_CallBackEntry*) malloc(basep->_vVMTCallBackSize * sizeof(VMT_CallBackEntry));
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the callback VMT table entries */
  
  basep->_pVMTCallBackTable = pVMTCBEntry;
  
  pVMTCBEntry->_vName = logicalIfMgmt_ifGetIfs_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_logicalIfMgmt_ifGetIfs;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_logicalIfMgmt_ifGetIfs;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = logicalIfMgmt_ifGetConfig_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_logicalIfMgmt_ifGetConfig;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_logicalIfMgmt_ifGetConfig;
  pVMTCBEntry++;
  
  pVMTCBEntry->_vName = logicalIfMgmt_ifGetFlags_opName;
  pVMTCBEntry->_pUserCallBackFuncPtr = (idl_ixa_c_userCallBack_fptr*) &pCBVMT->_pCB_logicalIfMgmt_ifGetFlags;
  pVMTCBEntry->_pCallBackFunc = deferred_cb_logicalIfMgmt_ifGetFlags;
  pVMTCBEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  
  basep->_vTokenType = IDL_IXA_C_CLIENT;
  basep->_pInterfaceName = logicalIfMgmt_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCallBackTable != 0)
      free(basep->_pVMTCallBackTable);
    if(basep->_pVMTCallBack != 0)
      free(basep->_pVMTCallBack);
    basep->_vVMTCallBackSize = 0;
    
    if(basep->_pVMTCrossCallRefTable != 0)
      free(basep->_pVMTCrossCallRefTable);
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    
  };
  return err;
}

/**=================================================
 * Stub finalizer for interface logicalIfMgmt
 *================================================*/
ix_error stub_logicalIfMgmt_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_fini";
  static const char* localInterfaceName = logicalIfMgmt_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_CLIENT)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of CLIENT type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCallBackTable);
  free(basep->_pVMTCallBack);
  basep->_vVMTCallBackSize = 0;
  
  free(basep->_pVMTCrossCallRefTable);
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/* Accessor function for callback VMT */
ix_error getCBVMT_logicalIfMgmt(const ix_base_t* basep, CB_VMT_logicalIfMgmt** pInterfaceCBVMT)
{
  static const char localFunctionName[] = "CB_VMT_logicalIfMgmt";
  static const char* localInterfaceName = logicalIfMgmt_intName;
  
  ix_error err = 0;
  
  *pInterfaceCBVMT = 0;
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_CLIENT)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of CLIENT type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  
  *pInterfaceCBVMT = (CB_VMT_logicalIfMgmt*) basep->_pVMTCallBack;
  
err_label1:
  return err;
}

/**=================================================
 * Define the interface operations
 *================================================*/
ix_error stub_logicalIfMgmt_ifGetIfs(ix_base_t* basep, long portNum)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifGetIfs";
  static const char* localOperationName = logicalIfMgmt_ifGetIfs_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifGetIfs);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_logicalIfMgmt_ifGetIfs;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for logicalIfMgmt::ifGetIfs deffered operation
 *================================================*/
ix_error deferred_cb_logicalIfMgmt_ifGetIfs(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_logicalIfMgmt_ifGetIfs";
  static const char* localOperationName = logicalIfMgmt_ifGetIfs_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_logicalIfMgmt_ifGetIfs, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tAIfConfig _cxx_if;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_ixa_c_seq_tIfConfig(&_cxx_if);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - sequence initialization failed for tAIfConfig!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_ixa_c_seq_tIfConfig(aSds, &_cxx_if);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for _cxx_if!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((logicalIfMgmt_ifGetIfs_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &_cxx_if);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback logicalIfMgmt_ifGetIfs_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_ixa_c_seq_tIfConfig(&_cxx_if);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - sequence finalization failed for tAIfConfig!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifGetConfig(ix_base_t* basep, long portNum, long ifNum)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifGetConfig";
  static const char* localOperationName = logicalIfMgmt_ifGetConfig_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifGetConfig);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_logicalIfMgmt_ifGetConfig;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for logicalIfMgmt::ifGetConfig deffered operation
 *================================================*/
ix_error deferred_cb_logicalIfMgmt_ifGetConfig(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_logicalIfMgmt_ifGetConfig";
  static const char* localOperationName = logicalIfMgmt_ifGetConfig_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_logicalIfMgmt_ifGetConfig, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  tIfConfig ifCfg;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  err = init_tIfConfig(&ifCfg);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - structure initialization failed for tIfConfig!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_tIfConfig(aSds, &ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifCfg!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((logicalIfMgmt_ifGetConfig_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, &ifCfg);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback logicalIfMgmt_ifGetConfig_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  err = fini_tIfConfig(&ifCfg);
  if(err)
  {
    ix_sds_del(aSds);
    return ix_error_new(0, 0, err, 
      "%s - structure finalization failed for tIfConfig!", localFunctionName);
  };
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifSetConfig(ix_base_t* basep, long portNum, long ifNum, const tIfConfig* ifCfg)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifSetConfig";
  static const char* localOperationName = logicalIfMgmt_ifSetConfig_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifSetConfig);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_tIfConfig(aSds, ifCfg);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifCfg!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifSetFlags(ix_base_t* basep, long portNum, long ifNum, unsigned long flags)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifSetFlags";
  static const char* localOperationName = logicalIfMgmt_ifSetFlags_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifSetFlags);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, flags);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for flags!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifGetFlags(ix_base_t* basep, long portNum, long ifNum)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifGetFlags";
  static const char* localOperationName = logicalIfMgmt_ifGetFlags_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = IX_OMS_SYSTEMTIMEOUT;
  
  /**=================================================
   * Allocate an ix_oms_callback_t structure for the deffered call 
   *================================================*/
  ix_oms_callback_t aCallbackStruct;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifGetFlags);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Fill in the ix_oms_callback_t structure for the deffered call 
   *================================================*/
  aCallbackStruct.callback = deferred_cb_logicalIfMgmt_ifGetFlags;
  aCallbackStruct.cookie = (void*)basep; /* for now the cookie is ix_base_t* */
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_DEFERRED, /* Call type, tells Muxer how to handle call. */
    &aCallbackStruct, /* Callback structure address */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}

/**=================================================
 * Definition of the deferred callback function for logicalIfMgmt::ifGetFlags deffered operation
 *================================================*/
ix_error deferred_cb_logicalIfMgmt_ifGetFlags(ix_error anError, void* cookie, ix_sds aSds)
{
  static const char localFunctionName[] = "deferred_cb_logicalIfMgmt_ifGetFlags";
  static const char* localOperationName = logicalIfMgmt_ifGetFlags_opName;
  
  VMT_CallBackEntry aVMTCBEntry = {0, deferred_cb_logicalIfMgmt_ifGetFlags, 0};
  ix_base_t* basep = (ix_base_t*) cookie;
  VMT_CallBackEntry* pVMTCBEntry;
  ix_error err = 0;
  unsigned long flags;
  /**=================================================
   * Initialize the callback parameters 
   *================================================*/
  
  if(!anError)
  {
    
    /**=================================================
     * Demarshal the callback parameters 
     *================================================*/
    err = ix_sds_p_ulong(aSds, &flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label1;
    };
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Callback for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  
  pVMTCBEntry = (VMT_CallBackEntry*) idl_ixa_c_bsearch(&aVMTCBEntry, basep->_pVMTCallBackTable, basep->_vVMTCallBackSize, sizeof(VMT_CallBackEntry), call_back_entry_predicate);
  
  if(pVMTCBEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - No callback function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  if(*pVMTCBEntry->_pUserCallBackFuncPtr == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Callback function is NULL for %s operation!", localFunctionName, localOperationName);
    
    goto err_label1;
  };
  
  /**=================================================
   * Invoke the user callback function
   *================================================*/
  err = ((logicalIfMgmt_ifGetFlags_cb_fptr) *pVMTCBEntry->_pUserCallBackFuncPtr)(basep, anError, flags);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - callback logicalIfMgmt_ifGetFlags_cb failed!", localFunctionName);
    goto err_label1;
  };
  
  if(!anError)
  {
    
    /**=================================================
     * Do all post callback processing 
     *================================================*/
    
  };
  
err_label1:
  
  /**=================================================
   * Finalize the callback parameters 
   *================================================*/
  {
    if(aSds)
    {
      /**=================================================
       * Delete the passed sds
       *================================================*/
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifAddIf(ix_base_t* basep, long portNum, long ifNum, const char* name, unsigned long ipV4Addr, unsigned long ipV4Mask)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifAddIf";
  static const char* localOperationName = logicalIfMgmt_ifAddIf_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifAddIf);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_string(aSds, name);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for name!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, ipV4Addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ipV4Addr!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, ipV4Mask);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ipV4Mask!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_logicalIfMgmt_ifRemoveIf(ix_base_t* basep, long portNum, long ifNum, unsigned long ipV4Addr, unsigned long ipV4Mask)
{
  static const char localFunctionName[] = "stub_logicalIfMgmt_ifRemoveIf";
  static const char* localOperationName = logicalIfMgmt_ifRemoveIf_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_logicalIfMgmt_ifRemoveIf);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_long(aSds, portNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for portNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_long(aSds, ifNum);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ifNum!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, ipV4Addr);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ipV4Addr!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_ulong(aSds, ipV4Mask);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for ipV4Mask!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}



/**=================================================
 * End stub definition of interface logicalIfMgmt
 *================================================*/



/**=================================================
 * Start stub definition of interface event
 *================================================*/


/* Declare the interface name for event interface */
const char event_intName[] = "event";

/* Define the local operation names for CC_VMT_event interface */

/* Define the name for event::eventRegister operation */
const char event_eventRegister_opName[] = "event_eventRegister";

/* Define the name for event::eventUnregister operation */
const char event_eventUnregister_opName[] = "event_eventUnregister";


/**=================================================
 * Stub initializer for interface event
 *================================================*/
ix_error stub_event_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "stub_event_init";
  /* static const char* localInterfaceName = event_intName; */
  
  ix_error err = 0;
  VMT_CrossCallEntry aVMTCCEntry = {0,0,0};
  VMT_CrossCallEntry* pVMTCCEntry;
  VMT_CrossCallRefEntry* pVMTCCREntry;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  basep->m_pCap = capp;
  basep->connected = 0;
  basep->connecterror = 0;
  basep->ns = 0;
  basep->ccname = 0;
  basep->user_connect_cb = 0;
  basep->cb_ctx = 0;
  basep->connectmutex = 0;
  
  if(sizeof(basep->m_pCommDesc.guid) <= strlen(event_intName))
  {
    strncpy(basep->m_pCommDesc.guid, event_intName, sizeof(basep->m_pCommDesc.guid) - 1);
    printf("Warning!\n\tThe GUID size is larger than the allocated space for the GUID\n\tin the communication descriptor structure!\n\tThe GUID has been trucated to %d characters!\n", sizeof(basep->m_pCommDesc.guid) - 1);
  }
  else
    strcpy(basep->m_pCommDesc.guid, event_intName);
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_event)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  pVMTCCREntry = (VMT_CrossCallRefEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallRefEntry));
  if(pVMTCCREntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall reference VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallRefTable = pVMTCCREntry;
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = event_eventRegister_opName;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = event_eventUnregister_opName;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  /* Intialize the crosscall reference table entries */
  
  aVMTCCEntry._vName = event_eventRegister_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_event_eventRegister;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  aVMTCCEntry._vName = event_eventUnregister_opName;
  pVMTCCEntry = (VMT_CrossCallEntry*) idl_ixa_c_bsearch(&aVMTCCEntry, basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  pVMTCCREntry->_pCrossCallRefFunc = (idl_ixa_c_crossCallRef_fptr) stub_event_eventUnregister;
  pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
  pVMTCCREntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallRefTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallRefEntry), cross_call_ref_entry_predicate);
  
  
  basep->_vTokenType = IDL_IXA_C_CLIENT;
  basep->_pInterfaceName = event_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCrossCallRefTable != 0)
      free(basep->_pVMTCrossCallRefTable);
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    
  };
  return err;
}

/**=================================================
 * Stub finalizer for interface event
 *================================================*/
ix_error stub_event_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "stub_event_fini";
  static const char* localInterfaceName = event_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_CLIENT)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of CLIENT type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCrossCallRefTable);
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/**=================================================
 * Define the interface operations
 *================================================*/
ix_error stub_event_eventRegister(ix_base_t* basep, const char* aceName)
{
  static const char localFunctionName[] = "stub_event_eventRegister";
  static const char* localOperationName = event_eventRegister_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_event_eventRegister);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_string(aSds, aceName);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for aceName!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}


ix_error stub_event_eventUnregister(ix_base_t* basep, const char* aceName)
{
  static const char localFunctionName[] = "stub_event_eventUnregister";
  static const char* localOperationName = event_eventUnregister_opName;
  
  ix_error err = 0;
  ix_sds aSds = 0;
  int opIndex;
  ix_timespan aTimeout = 0;
  
  opIndex = getIDLOperationIndex(basep, (idl_ixa_c_crossCallRef_fptr)stub_event_eventUnregister);
  if(opIndex < 0)
  {
    return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
      IX_ERROR_LEAD_FMT("method not found in interface")
      "\t%s - unable to locate method %s in interface\n"
      "\tgetIDLOperationIndex returns %d\n",
      IX_ERROR_LEAD_ARGS, localFunctionName, localOperationName, opIndex);
    
  };
  
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Operation %s called!\n",localFunctionName, localOperationName);
  printf("\t%s - Operation index is : %d\n",localFunctionName, opIndex);
#endif /* _IDL_OUTPUT_DEBUG */
  
  /**=================================================
   * Create an SDS 
   *================================================*/
  err = ix_sds_new(&aSds);
  if(err) return ix_error_new(0, 0, err, 
    "%s - ix_sds_new failed!", localFunctionName);
  
  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  err = ix_sds_r_int(aSds, 0);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS header marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
  err = ix_sds_r_int(aSds, opIndex);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - SDS operation ID marshaling failed!", localFunctionName);
    goto err_label1;
  };
  
  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
  err = ix_sds_r_string(aSds, aceName);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - argument marshaling failed for aceName!", localFunctionName);
    goto err_label1;
  };
  
  err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
    basep->m_pCommDesc, /* Communication descriptor */
    &aSds, /* Message to send */
    OMS_CT_ONEWAY, /* Call type, tells Muxer how to handle call. */
    NULL, /* Callback not used for one way */
    aTimeout);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dxProcMessage() failed!", localFunctionName);
    goto err_label1;
  };
  
  return err;
  
err_label1:
  {
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
    if(aSds)
    {
      ix_error err1 = ix_sds_del(aSds);
      if(err1) err = ix_error_new(0, 0, err1, 
        "%s - ix_sds_del failed!", localFunctionName);
    };
  };
  return err;
}



/**=================================================
 * End stub definition of interface event
 *================================================*/

