#ifndef __NPAPI_H
#define __NPAPI_H

#define NPAPISPORT	50000
#define NPAPISPORT_STR	"50000"


enum
{
  GET = 1,
  GETFROM = 2,
  CANREAD = 3,
  CANWRITE = 4,
  SEND = 5,
  OK = 0,
  ERR = (unsigned char)-1,
  INGRESS = 1,
  EGRESS  = 2,
  MTU     = 1500
};


/* For ACES only */

#ifdef __IX_ASL_ASL_H__
ix_error init_api_server(ix_ace *);
ix_error fini_api_server(void);
#endif


/* For ACEs and applications */


struct fbuffer
{
  int len;
  int ifnum;
  int ofnum;
  char frame[1];
};


int np_start(char *addr, char *iname);

void np_stop(void);

void recv_frame(int ifnum, struct fbuffer *buf);

void next_frame(struct fbuffer *buf);

void send_frame(struct fbuffer *buf, int safill);

int iface_ready(int ifnum, int direction);

struct fbuffer *new_fbuf(int flen);

int set_promisc(char *iname, int port, int on);

int get_mac(char *iname, int port, unsigned char addr[6]);


#endif /* __NPAPI_H */
