/*
 * cat_net.h
 * 
 * Christopher Adam Telfer
 * 
 * Copyright 1999 -- All rights reserved
 * 
 */ 

#ifndef __CAT_NET_H
#define __CAT_NET_H

/* Socket functions */
int cat_tcp_passive(const char *host, const char *serv, int *addrlen);
int cat_tcp_connect(const char *host, const char *serv);
int cat_udp_passive(char *host, char *serv, int *addrlen);
int cat_udp_active(char *host, char *serv, void *raddr, int *raddrlen);
int cat_udp_connect(char *host, char *serv);

/* I/O functions */
int readn(int, void *, int); 
int writen(int, void *, int); 
int cat_readline(int fd, void *buf, int maxlen);

/* Necessary for struct sockaddr */
#include <sys/socket.h>
/* More useful stuff */
const char *cat_ntoa(struct sockaddr *sa, char *buffer, int len);


/* Wrappers */

int Cat_tcp_passive(const char *host, const char *serv, int *addrlen);
int Cat_tcp_connect(const char *host, const char *serv);
int Cat_udp_passive(char *host, char *serv, int *addrlen);
int Cat_udp_active(char *host, char *serv, void *raddr, int *raddrlen);
int Cat_udp_connect(char *host, char *serv);
int Readn(int, void *, int); 
int Writen(int, void *, int); 
int Cat_readline(int fd, void *buf, int maxlen);


#endif /* __CAT_NET_H */
