/*---------------------------------------------------------------------
 *
 *        File Name: dl_system.h
 *
 *        Purpose: This file contains system wide parameters
 *                 that are customized for a given application.
 *
 *--------------------------------------------------------------------*/

/**************************************************************/
/* This file is adapted from examples in the Intel SDK and    */
/* parts of the code are covered by Intel copyright.  You     */
/* only have permission to use this file if you have obtained */
/* a copy of the SDK from Intel.                              */
/**************************************************************/

#ifndef	__DL_SYSTEM__H__
#define	__DL_SYSTEM__H__

/*	Chip is IXP2400 */
#ifndef IXP2400
#define IXP2400
#endif	

/* Define project as microcode based. */
#ifndef IXP_MICROCODE
#define IXP_MICROCODE
#endif

/* Phy modes */
#define TX_PHY_MODE 						MPHY_4
#define RX_PHY_MODE						MPHY_4


/*---------------------------------------------------------------------
 * Include global definition and configuration files
 *-------------------------------------------------------------------*/

/* This file is also used by script files that setup the system when run 
 * in simulation mode. When symbol IXP_SCRIPTS is defined, it indicates
 * that scripts are using this file. Since script files cannot access
 * path definitions, they should not encounter '#include <file>'. Instead
 * they include the <file> using Simulation -> Options -> Startup.
 */
#ifndef IXP_SCRIPTS
#include <definitions.h>
#include <ix_cc_microengines_bindings.h>
#ifndef IXP_MICROCODE
#include <ixp.h> /* for micro-c */
#endif
#endif


/*---------------------------------------------------------------------
 * Miscellaneous settings.
 *-------------------------------------------------------------------*/

#ifndef		USE_IMPORT_VAR

/* Freelist id that is stored in meta data */
#ifndef		FREE_LIST_ID
#define		FREE_LIST_ID		0x0
#endif

/* This blade's id */
#ifndef		THIS_BLADE_ID
#define		THIS_BLADE_ID		0x3f 
#endif

#endif /* USE_IMPORT_VAR */

#ifdef		USE_IMPORT_VAR

/* Patched by core */
.import_var DL_REL_BASE
.import_var BUF_FREE_LIST0
.import_var BUF_SRAM_BASE
#endif /* USE_IMPORT_VAR */

/*---------------------------------------------------------------------
 * SRAM memory map for channel 0.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

 /* Area of SRAM which is zero'ed out. */
#ifndef		SRAM_ZERO_BLOCK
#define		SRAM_ZERO_BLOCK 	0x0
#endif

#endif /* USE_IMPORT_VAR */

/*---------------------------------------------------------------------
 * Base address for meta data (buffer descriptors) of packet 
 * buffers.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

#ifndef		BUF_SRAM_BASE
#define		BUF_SRAM_BASE		0
#endif

#endif /* USE_IMPORT_VAR */

/* Total SRAM size allocated in bytes for meta data.
   In simulation we use only 20KB. */
#ifndef		BUF_SRAM_SIZE
#ifdef 		IXP_SIMULATION
#define		BUF_SRAM_SIZE		(1024 * 10 * 2)
#else
#define		BUF_SRAM_SIZE		(1024 * 10 * 2 * 20)
#endif
#endif

/* Size of meta-data (buffer descriptor) in bytes for each buffer.
   Should be a power of 2. */
#ifndef		META_DATA_SIZE
#define		META_DATA_SIZE		32
#endif

/*---------------------------------------------------------------------
 * Base address for queue descriptors.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

#ifndef		QD_SRAM_BASE
#define		QD_SRAM_BASE		0x100000
#endif

/* Total number of queue descriptors. */
#ifndef		QD_TOTAL
#define		QD_TOTAL			1024
#endif

#endif /* USE_IMPORT_VAR */


/*---------------------------------------------------------------------
 * Base address for TX counters.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

/*
 * Packet TX needs 16*3 counters and each counter is 1LW 
 * this implies 48*4 bytes. We start Packet TX counters from 0x64000, 
 * to provide memory for any additional counters in future.
 */
#ifndef		PACKET_TX_COUNTER_BASE
#define		PACKET_TX_COUNTER_BASE		0x64000
#endif

#endif /* USE_IMPORT_VAR */


/*---------------------------------------------------------------------
 * Base address for POS RX counters.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

/* Base for POS RX counters */
#ifndef		PACKET_COUNTERS_SRAM_BASE
#define		PACKET_COUNTERS_SRAM_BASE	0x40065000
#endif

#endif /* USE_IMPORT_VAR */


/*---------------------------------------------------------------------
 * SRAM Q-array memory map.
 *-------------------------------------------------------------------*/

/* SRAM q-array entries 0-15 are used by the queue manager to cache queues */
#ifndef		QM_QARRAY_BASE
#define		QM_QARRAY_BASE			0
#endif

#ifndef		QM_QARRAY_SIZE
#define		QM_QARRAY_SIZE			16
#endif

#ifndef		USE_IMPORT_VAR

/* SRAM q-array entries allocated for buffer free list. */
#ifndef		BUF_QARRAY_BASE
#define		BUF_QARRAY_BASE			16
#endif

#ifndef		BUF_QARRAY_SIZE
#define		BUF_QARRAY_SIZE			4
#endif

/* SRAM q-array entry allocated for drop queue in queue manager. */
#ifndef		QM_DROP_QUEUE_ENTRY
#define		QM_DROP_QUEUE_ENTRY		20
#endif

/* Queue Number for Drop Queue.
 * (0-1023 are the normal queues used in forwarding pkts)
 */
#define		QM_DROP_QUEUE			1024

#else 

#define         QM_DROP_QUEUE                   1024 

#endif /* USE_IMPORT_VAR */


/*---------------------------------------------------------------------
 * DRAM memory map.
 *-------------------------------------------------------------------*/

/* The DDR (Double Data Rate) DRAM bank size is used to randomize 
   buffer offset. */
#ifndef		DDR_BANK_SIZE
#define		DDR_BANK_SIZE			128
#endif

/* Number of DDR banks. */
#ifndef		NO_OF_DDR_BANKS
#define		NO_OF_DDR_BANKS			4
#endif

#define		MAX_BUFFER_OFFSET		(DDR_BANK_SIZE * NO_OF_DDR_BANKS)


/*---------------------------------------------------------------------
 * Base address for packet buffers. This is the actual packet data.
 *-------------------------------------------------------------------*/
#ifndef		USE_IMPORT_VAR

#ifndef		BUF_SDRAM_BASE
#define		BUF_SDRAM_BASE		0
#endif

#endif /* USE_IMPORT_VAR */

/* Total DRAM size allocated in bytes for packet buffers.
   In simulation we use only 1280KB. */
#ifndef		BUF_SDRAM_SIZE
#ifdef 		IXP_SIMULATION
#define		BUF_SDRAM_SIZE		(64 * 1024 * 10 * 2)
#else
#define		BUF_SDRAM_SIZE		(64 * 1024 * 10 * 2 * 20)
#endif
#endif

/*	Size of one packet buffer in bytes.  */
#ifndef		BUFFER_SIZE
#define		BUFFER_SIZE			2048
#endif

/* Allocating 64 MB of DRAM for packet buffers. */


/*---------------------------------------------------------------------
 * Scratch and scratch ring memory map.
 *-------------------------------------------------------------------*/

/*  There are two exception ring to send pkts up */
#ifndef		EXCEPTION_RING_OUT_0
#define		EXCEPTION_RING_OUT_0			0
#endif

#ifndef		EXCEPTION_RING_OUT_1
#define		EXCEPTION_RING_OUT_1			1
#endif

/*  There are two exception ring to send pkts down */
#ifndef		EXCEPTION_RING_IN_0
#define		EXCEPTION_RING_IN_0				2
#endif

#ifndef		EXCEPTION_RING_IN_1
#define		EXCEPTION_RING_IN_1				3
#endif

#include <NAT_scratch_rings.h>

/* These defines are used by the individual microcode to identify their
 * scratch rings. The reason for these defines is to improve the portability
 * of microblocks. User just has to make changes here and the microblocks will
 * remain untouched. For the naming convention, the microblock name goes first,
 * then the _RING_ specifier. Following this is the direction indicator.
 * '_OUT' would imply the microblock is writing to this scratch ring and
 * '_IN' would imply the microblock is reading from this scratch ring.
 * If there is more than one 'IN' or 'OUT' ring the name will have '_<digit>'
 * to differentiate the rings.
 * An '_IND' at the end indicates the compilation switch.
 */

#ifndef		PACKET_TX_IN_0_IND
#define		PACKET_TX_IN_0_IND
#define		PACKET_TX_IN_0				PACKET_TX_SCR_RING_0
#define		PACKET_TX_IN_0_BASE			PACKET_TX_SCR_RING_0_BASE
#define		PACKET_TX_IN_0_SIZE			PACKET_TX_SCR_RING_0_SIZE
#endif		/* PACKET_TX_IN_0_IND */

#ifndef		PACKET_TX_IN_1_IND
#define		PACKET_TX_IN_1_IND
#define 	PACKET_TX_IN_1				PACKET_TX_SCR_RING_1
#define		PACKET_TX_IN_1_BASE			PACKET_TX_SCR_RING_1_BASE
#define		PACKET_TX_IN_1_SIZE			PACKET_TX_SCR_RING_1_SIZE
#endif		/* PACKET_TX_IN_1_IND */

#ifndef		PACKET_TX_IN_2_IND
#define		PACKET_TX_IN_2_IND								
#define		PACKET_TX_IN_2				PACKET_TX_SCR_RING_2
#define		PACKET_TX_IN_2_BASE			PACKET_TX_SCR_RING_2_BASE
#define		PACKET_TX_IN_2_SIZE			PACKET_TX_SCR_RING_2_SIZE
#endif		/* PACKET_TX_IN_2_IND */

#ifndef		PACKET_TX_IN_3_IND
#define		PACKET_TX_IN_3_IND
#define 	PACKET_TX_IN_3				PACKET_TX_SCR_RING_3
#define		PACKET_TX_IN_3_BASE			PACKET_TX_SCR_RING_3_BASE
#define		PACKET_TX_IN_3_SIZE			PACKET_TX_SCR_RING_3_SIZE
#endif		/* PACKET_TX_IN_3_IND */

#ifdef IXP_MICROCODE

/* Ring number to use. 0-15. */
#define_eval 	DL_RING_NUMBER		PKT_RX_TO_NAT_SCR_RING
#define_eval	DL_DROP_RING		PKT_RX_TO_NAT_SCR_RING

#else

/* Ring number to use. 0-15. */
#define		 	DL_RING_NUMBER		PKT_RX_TO_NAT_SCR_RING

#endif	/* IXP_MICROCODE */

/* Valid values for RING_SIZE are 128, 256, 512 or 1024. */
#ifndef			DL_RING_SIZE
#define 		DL_RING_SIZE		PKT_RX_TO_NAT_SCR_RING_SIZE
#endif

/* Base Address for Scratch Ring is 0x1000. Should be aligned 
 * on a 4 x RING_SIZE byte boundary.
 */
#ifndef			DL_RING_BASE
#define 		DL_RING_BASE		PKT_RX_TO_NAT_SCR_RING_BASE
#endif


/*---------------------------------------------------------------------
 * System-wide signals.
 *-------------------------------------------------------------------*/

/* Signals being a precious resource, we use a single signal for 
 * inter-thread as well as any other inter-me signalling
 * (init over signal).
 */
#ifndef		COMMON_INTER_THD_ME_SIGNAL
#define		COMMON_INTER_THD_ME_SIGNAL		10
#endif

/* We are not able to use a single signal before of limitations in
 * assembler. Until then, we need a separate signal for inter-thread
 * signalling.
 */
#ifndef		INTER_THD_SIGNAL
#define		INTER_THD_SIGNAL				12
#endif

/* ME_INIT_SIGNAL signal is used to let all ME's know that system
 * initialization is over and all blocks in all MEs can start running.
 * This signal will be typically issued by the system initialization code
 * and all other MEs should wait for this signal before starting to run. 
 */
#ifndef		ME_INIT_SIGNAL
#define		ME_INIT_SIGNAL					COMMON_INTER_THD_ME_SIGNAL
#endif

/* Signal number to use in inter thread signalling. */
#ifndef		DL_SIG_WAKE
#define 	DL_SIG_WAKE						INTER_THD_SIGNAL
#endif


/*---------------------------------------------------------------------
 * System communication ID's and block ID's.
 *-------------------------------------------------------------------*/

/* These tell if the executing threads need to work in order.
 * i.e wait for	a signal from prev thread, do some work and signal
 * next thread. */
#ifndef		DL_THREAD_NO_ORDER
#define		DL_THREAD_NO_ORDER	0x0
#endif

#ifndef		DL_THREAD_ORDER
#define		DL_THREAD_ORDER		0x1
#endif

/* All the IX_* constants should be between 0 and 255 (i.e 1 byte)
 * to enable using them as immed operands in instructions.
 *
 * IX_NULL is used to denote a NULL (or empty) packet handle. 
 * It should not be zero, as it would interfere with ring empty (0)
 * condition.
 * Note: IX_NULL is too generic a name and may clash with core
 *  components code. So it's marked for deletion. Start using UC_NULL.
 */

#ifndef		IX_NULL
#define		IX_NULL				0xFF
#endif

#ifndef		IX_EXCEPTION
#define		IX_EXCEPTION		0x1
#endif

#ifndef		IX_DROP
#define		IX_DROP				0x2
#endif

#ifndef		UC_NULL
#define		UC_NULL				0xFF		/* NULL for microcode */
#endif

#ifndef		DL_BUF_NULL
#define		DL_BUF_NULL			UC_NULL 	/* NULL buffer */
#endif

#ifndef		BID_NULL
#define		BID_NULL			UC_NULL		/* NULL block ID */
#endif

#ifndef		BID_EXCEPTION
#define		BID_EXCEPTION		0x1			/* Exception block ID */
#endif

#ifndef		BID_DROP
#define		BID_DROP			0x2			/* Drop block ID */
#endif

/* Block IDs for various blocks. Block IDs Start from 0x20.
 * (0x0 to 0x1f and 0xFF are reserved for IX_*).
 */
#ifndef		BID_POS
#define		BID_POS					IX_CC_POS_RX_PKT_ID
#endif

#ifndef		BID_IPV4
#define		BID_IPV4				IX_CC_IPV4_PKT_MICROBLOCK_ID
#endif

#ifndef		BID_QM
#define		BID_QM					0x23
#endif

#ifndef		BID_ETHER
#define 	BID_ETHER				IX_CC_ETH_RX_PKT_ID
#endif

#ifndef		BID_IPV6
#define		BID_IPV6	            IX_CC_IPV6_PKT_MICROBLOCK_ID
#endif

#ifndef		BID_ARP
#define		BID_ARP					IX_EXCEPTION
#endif

#ifndef		BID_ETHER_PPP_DISCOVERY
#define		BID_ETHER_PPP_DISCOVERY	IX_EXCEPTION
#endif

#ifndef		BID_ETHER_PPP_SESSION
#define		BID_ETHER_PPP_SESSION	IX_EXCEPTION
#endif

#ifndef		BID_MPLSILM
#define		BID_MPLSILM				0x29
#endif

/*	To be redefined as an import variable. And its value should 
 *	be one of the above block IDs.
 */

#ifndef		BID_NEXT_BLOCK
#define		BID_NEXT_BLOCK			BID_QM					
#endif

#endif /* __DL_SYSTEM__H__ */

