/* NAT_types.h  -  types used by the core component and user interface */

typedef struct nat_entry_s {	/* An entry in a NAT table */
	unsigned int valid : 1;
	unsigned int unused : 7;
	unsigned int prot : 8;
	unsigned int nport : 16;
	unsigned int lport : 16;
	unsigned int rport : 16;
	unsigned int ip_addr_loc;
	unsigned int ip_addr_rem;
} nat_entry;

typedef struct arp_entry_s {	/* An entry in the ARP cache */
	unsigned int ip_addr;
	unsigned int eth_w0;
	unsigned short eth_w1;
	unsigned short ifnum : 15;
	unsigned short valid : 1;
	unsigned int unused;
} arp_entry;

typedef struct net_if_s {	/* Network interface structure */
	unsigned int ip_addr;
	unsigned int eth_w0;
	unsigned int eth_w1;
} net_if;

typedef enum nat_cmd_t {	/* Possible ioctl commands for	*/
				/*   the NAT pseudo-device	*/
	SILENT=0, VERBOSE,
	GET_RX_COUNTER, CLR_RX_COUNTER,
	GET_TX_COUNTER, CLR_TX_COUNTER,
	GET_ARP_TABLE,  GET_NAT_TABLE,  GET_TIMER_TABLE
} nat_cmd;
#define INVALID_CMD -1
