/* ds_sed_ip_ethernet.asl - SED script for DiffServ example		*/

#include "sedNp5.h"

/*
 *------------------------------------------------------------------------
 * DiffServ for IP over Ethernet
 */
script DS_ip_ethernet {

  unsigned    prm_dst_mac     param_block[0:5];
  unsigned    prm_src_mac     param_block[6:11];

  /* DSCP value, passed by FPP */
  unsigned    prm_dscp        flags[0];

  /* 
   * Only the first block of the PDU is modified.  All other blocks are
   * passed through the SED CE without modification.
   */
  if (is_first) {

     /*
      * The format of the first output data block.
      * It consists of an Ethernet MAC header followed by an IP header.
      * Within the IP header, the TOS, TTL and the checksum fields are
      * defined.
      */
     unsigned        dst_mac data_block[0:5];
     unsigned        src_mac data_block[6:11];
     block           ip_header data_block[14:33];
     unsigned        ip_tos ip_header[1];
     unsigned        ip_ttl ip_header[8];
     unsigned        ip_checksum ip_header[10:11];
     unsigned(4)     checksum;
     unsigned(2)     temp;

     /* Fill in source & destination MAC addresses from parameter block */
     dst_mac = prm_dst_mac;
     src_mac = prm_src_mac;

     /* 
      * Update ttl field.  Assuming that FPL code has already
      * verified that it is nonzero
      */
     ip_ttl = ip_ttl - 1;

     /* Set TOS (DSCP) and adjust the checksum */
     temp = prm_dscp; /* overcoming conversion problems */
     checksum = ip_checksum + ip_tos + 0x0100 + (~temp);
     ip_tos = prm_dscp;

     /* Wrap checksum carry around */
     checksum = checksum[0:1]+checksum[2:3];
     checksum = checksum[0:1]+checksum[2:3];
     ip_checksum = checksum[2:3];
  }
}
