/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;
import ptolemy.plot.compat.PxgraphParser;

public class PxgraphApplication
extends PlotApplication {
    private PxgraphParser _parser;

    public PxgraphApplication() throws Exception {
        this(null);
    }

    public PxgraphApplication(Plot plot, String[] args) throws Exception {
        super((PlotBox)plot, args);
    }

    public PxgraphApplication(String[] args) throws Exception {
        this(new Plot(), args);
    }

    protected void _about() {
        JOptionPane.showMessageDialog((Component)((Object)this), "               pxgraph\n        A Java Plotting Tool\n\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n    Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.1p2, Build: $Id: PxgraphApplication.java,v 1.15 2001/01/25 18:17:01 cxh Exp $\n\nFor help, type 'pxgraph -help', or see \nthe class documentation in the plot.pxgraph package.\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n", "About pxgraph", 1);
    }

    protected int _parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        String title = "Ptolemy plot, pxgraph version";
        int width = 400;
        int height = 300;
        while (args != null && i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-help")) {
                System.out.println(this._usage());
                System.exit(0);
                continue;
            }
            if (arg.equals("-test")) {
                PlotApplication._test = true;
                continue;
            }
            if (arg.equals("-t")) {
                title = args[i++];
                continue;
            }
            if (arg.equals("-v") || arg.equals("-version")) {
                System.out.println("Version 5.1p2, Build $Id: PxgraphApplication.java,v 1.15 2001/01/25 18:17:01 cxh Exp $");
                System.exit(0);
                continue;
            }
            if (!arg.startsWith("=")) continue;
            int xscreen = 1;
            int yscreen = 1;
            boolean screenlocationgiven = false;
            StringTokenizer stoken = new StringTokenizer(arg.substring(1, arg.length()), "=x-+");
            if (stoken.hasMoreTokens()) {
                width = Integer.valueOf(stoken.nextToken());
            }
            if (stoken.hasMoreTokens()) {
                height = Integer.valueOf(stoken.nextToken());
            }
            if (stoken.hasMoreTokens()) {
                xscreen = Integer.valueOf(stoken.nextToken());
                screenlocationgiven = true;
            }
            if (stoken.hasMoreTokens()) {
                yscreen = Integer.valueOf(stoken.nextToken());
                screenlocationgiven = true;
            }
            if (!screenlocationgiven) continue;
            ((Component)((Object)this)).setLocation(new Point(xscreen + 1, yscreen + 1));
        }
        ((Component)((Object)this)).setSize(width, height);
        ((Frame)((Object)this)).setTitle(title);
        int argumentsRead = i++;
        if (this._parser == null) {
            this._parser = new PxgraphParser((Plot)((PlotFrame)this).plot);
        }
        this._parser.parseArgs(args);
        return argumentsRead;
    }

    protected void _read(URL base, InputStream in) throws IOException {
        this._parser.read(in);
    }

    protected String _usage() {
        String[][] commandOptions = new String[][]{{"-bd", "<color>", "Border", "White", "(Unsupported)"}, {"-bg", "<color>", "BackGround", "White", ""}, {"-brb", "<base>", "BarBase", "0", "(Unsupported)"}, {"-brw", "<width>", "BarWidth", "1", ""}, {"-bw", "<size>", "BorderSize", "1", "(Unsupported)"}, {"-fg", "<color>", "Foreground", "Black", ""}, {"-gw", "<pixels>", "GridStyle", "1", "(Unsupported)"}, {"-lf", "<fontname>", "LabelFont", "helvetica-12", ""}, {"-lw", "<width>", "LineWidth", "0", "(Unsupported)"}, {"-lx", "<xl,xh>", "XLowLimit, XHighLimit", "0", ""}, {"-ly", "<yl,yh>", "YLowLimit, YHighLimit", "0", ""}, {"-o", "<output filename>", "", "/tmp/t.ps", ""}, {"-t", "<title>", "TitleText", "An X Graph", ""}, {"-tf", "<fontname>", "TitleFont", "helvetica-b-14", ""}, {"-x", "<unitName>", "XUnitText", "X", ""}, {"-y", "<unitName>", "YUnitText", "Y", ""}, {"-zg", "<color>", "ZeroColor", "Black", "(Unsupported)"}, {"-zw", "<width>", "ZeroWidth", "0", "(Unsupported)"}};
        String[][] commandFlags = new String[][]{{"-bar", "BarGraph", ""}, {"-bb", "BoundBox", "(Ignored)"}, {"-bigendian", "", ""}, {"-littleendian", "", ""}, {"-binary", "Binary", ""}, {"-impulses", "Impulses", ""}, {"-help", "", ""}, {"-lnx", "XLog", ""}, {"-lny", "YLog", ""}, {"-m", "Markers", ""}, {"-M", "StyleMarkers", ""}, {"-nl", "NoLines", ""}, {"-p", "PixelMarkers", ""}, {"-P", "LargePixel", ""}, {"-rv", "ReverseVideo", ""}, {"-test", "Test", ""}, {"-tk", "Ticks", ""}, {"-v", "Version", ""}, {"-version", "Version", ""}};
        String result = "Usage: ptplot [ options ] [=WxH+X+Y] [file ...]\n\n options that take values as second args:\n";
        int i = 0;
        while (i < commandOptions.length) {
            result = String.valueOf(result) + " " + commandOptions[i][0] + " " + commandOptions[i][1] + " " + commandOptions[i][4] + "\n";
            ++i;
        }
        result = String.valueOf(result) + "\nBoolean flags:\n";
        i = 0;
        while (i < commandFlags.length) {
            result = String.valueOf(result) + " " + commandFlags[i][0] + " " + commandFlags[i][2] + "\n";
            ++i;
        }
        result = String.valueOf(result) + "\nThe following pxgraph features are not supported:\n * Directives in pxgraph input files\n * Xresources\n";
        return result;
    }

    public static void main(String[] args) {
        try {
            PxgraphApplication plot = new PxgraphApplication(new Plot(), args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (PlotApplication._test) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }
}

