/*
 * ==============================================================
 * components_mex.c The mex interface to the matlab bgl wrapper.
 *
 * David Gleich
 * 21 April 20020
 * =============================================================
 */

#include "mex.h"

#include "matlab_bgl.h"

#include <math.h>
#include <stdlib.h>

void expand_to_double(int* src, double* dst, int len, double offset)
{
    int i;
    for (i = len-1; i>=0; i--)
    {
        dst[i] = (double)src[i] + offset;
    }
}

/*
 * The mex function runs a connected components problem.
 */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
    int i,j,k;
    
    int mrows, ncols;
    
    int n,nz;
    
    /* sparse matrix */
    int *ia, *ja;
    
    /* source/sink */
    int u;
    
    /* output data */
    double *ci, *sizes;
    int* int_ci;
    
    int num_cc;
    
    
    if (nrhs != 1) 
    {
        mexErrMsgTxt("1 inputs required.");
    }

    /* The first input must be a sparse matrix. */
    mrows = mxGetM(prhs[0]);
    ncols = mxGetN(prhs[0]);
    if (mrows != ncols ||
        !mxIsSparse(prhs[0]) ||
        !mxIsDouble(prhs[0]) || 
        mxIsComplex(prhs[0])) 
    {
        mexErrMsgTxt("Input must be a noncomplex square sparse matrix.");
    }
    
    n = mrows;
        
    
    
    /* Get the sparse matrix */
    
    /* recall that we've transposed the matrix */
    ja = mxGetIr(prhs[0]);
    ia = mxGetJc(prhs[0]);
    
    nz = ia[n];
    
    
    plhs[0] = mxCreateDoubleMatrix(n,1,mxREAL);
    
    ci = mxGetPr(plhs[0]);
    

    
    strong_components(n, ja, ia,
        (int*)ci);
    

    
    /* count the number of components */
    int_ci = (int*)ci;
    num_cc = 0;
    for (i=0;i<n;i++)
    {
        if (int_ci[i] > num_cc)
        {
            num_cc++;
        }
    }
    
    /* add one to the total because we computed the max index */
    num_cc++;
    
    plhs[1] = mxCreateDoubleMatrix(num_cc,1,mxREAL);
    sizes = mxGetPr(plhs[1]);
    
    for (i=0;i<num_cc;i++)
    {
        sizes[i] = 0.0;
    }
   
        
    for (i=0;i<n;i++)
    {
        sizes[int_ci[i]] += 1.0;
    }
    
    
    expand_to_double((int*)ci, ci, n, 1.0);
}

