/*
 * ==============================================================
 * betweenness_centrality_mex.c The mex interface to the matlab bgl wrapper.
 *
 * David Gleich
 * 23 April 2006
 * =============================================================
 */

#include "mex.h"

#include "matlab_bgl.h"

#include <math.h>
#include <stdlib.h>




/*
 * The mex function runs a betweenness-centrality problem.
 */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
    int i,j,k;
    
    int mrows, ncols;
    
    int n,nz;
    
    /* sparse matrix */
    int *ia, *ja;
    double *a;
    
    /* output data */
    double *bc;
    
    /* used to switch between algorithm types */
    int unweighted;
     
    if (nrhs != 2) 
    {
        mexErrMsgTxt("2 inputs required.");
    }
    
    /* The second input must be a scalar. */
    if (mxGetNumberOfElements(prhs[1]) > 1 || !mxIsDouble(prhs[1]))
    {
        mexErrMsgTxt("Invalid scalar.");
    }
    
    /* get the scalar, because it affects what type of matrices we can look at */
    unweighted = (int)mxGetScalar(prhs[1]);

    /* The first input must be a sparse matrix. */
    mrows = mxGetM(prhs[0]);
    ncols = mxGetN(prhs[0]);
    if (mrows != ncols ||
        !mxIsSparse(prhs[0]) ||
        ((!mxIsDouble(prhs[0]) || mxIsComplex(prhs[0])) && !unweighted)
        )
    {
        mexErrMsgTxt("Input must be a square sparse matrix.");
    }
    
    n = mrows;
         
    
    /* Get the sparse matrix */
    
    /* recall that we've transposed the matrix */
    ja = mxGetIr(prhs[0]);
    ia = mxGetJc(prhs[0]);
    
    nz = ia[n];
    
    
    
    plhs[0] = mxCreateDoubleMatrix(n,1,mxREAL);
    
    /* create the output vectors */    
    bc = mxGetPr(plhs[0]);
    
    if (unweighted)
    {
        betweenness_centrality(n, ja, ia, NULL,
            bc);
    }
    else
    {
        a  = mxGetPr(prhs[0]);
        betweenness_centrality(n, ja, ia, a,
            bc);
    }
}

