function [out1 out2 out3] = biconnected_components(A,varargin)
% MST Compute a minimum spanning tree for an undirected graph A.
%
% There are two ways to call MST.
% T = mst(A)
% [i j v] = mst(A) 
% The first call returns the minimum spanning tree T of A.  
% The second call returns the set of edges in the minimum spanning tree.  
% The calls are related by 
%    T = sparse(i,j,v,size(A,1), size(A,1)); 
%    T = max(T,T');
% The optional algname parameter chooses which algorithm to use to compute
% the minium spanning tree.  Note that the set of edges returned is not
% symmetric and the final graph must be explicitly symmetrized.
%
% This method works on undirected graphs graphs.
%
% ... = mst(A,optionsu) sets optional parameters (see 
% set_matlab_bgl_options) for the standard options.
%   options.algname: the minimum spanning tree algorithm
%     [{'prim'} | 'kruskal']
%
% Note: the input to this function must be symmetric, so this function
% ignores the 'notrans' default option and never transposes the input.
%
% Example:
%    load graphs/clr-24-1.mat
%    mst(A)
%
% See also PRIM_MST, KRUSKAL_MST


[trans check] = get_matlab_bgl_options(varargin{:});

options = struct('algname', 'prim');
if (length(varargin) > 0)
    options = merge_structs(varargin{1}, options);
end;

if (check)
    % make sure the matrix is symmetric
    check_matlab_bgl(A,struct('sym',1,'values',1));
end;

[i j v] = mst_mex(A,lower(options.algname));
if (nargout == 1 || nargout == 0)
    T = sparse(i,j,v,size(A,1),size(A,1));
    T = max(T,T');
    out1 = T;
else
    out1 = i; 
    out2 = j;
    out3 = v;
end;





