function [d pred] = dijksta_sp(A,u,varargin)
% DIJKSTRA_SP Compute the weighted single source shortest path problem.
%
% Dijkstra's algorithm for the single source shortest path problem only
% works on graphs without negative edge weights.
%
% This method works on weighted directed graphs without negative edge
% weights.
% The runtime is O(V log (V)).
%
% See the shortest_paths function for calling information.  This function 
% just calls shortest_paths(...,struct('algname','dijkstra'));
%
% Example:
%    load graphs/clr-25-2.mat
%    dijkstra_sp(A,1)
%
% See also SHORTEST_PATHS, BELLMAN_FORD_SP.

%
% David Gleich
% 23 April 2006
%

algname = 'dijkstra';

if (nargin > 2)
    options = varargin{1};
    options.algname = algname;
else
    options = struct('algname',algname);
end;

[d pred] = shortest_paths(A,u,options);




