function [ci sizes] = components(A,varargin)
% COMPONENTS Compute the connected components of a graph.
%
% [ci sizes] = components(A) returns the component index vector (ci) and
% the size of each of the connected components (sizes).  The number of
% connected components is max(components(A)).  The algorithm used computes
% the strongly connected components of A, which are the connected
% components of A if A is undirected (i.e. symmetric).  
%
% This method works on directed graphs.
% The runtime is O(V+E), the algorithm is just depth first search.
%
% ... = components(A,u,options) sets optional parameters (see 
% set_matlab_bgl_options) for the standard options.
%   There are no additional options for this function.
%
% Note: this function does not depend upon the non-zero values of A, but
% only uses the non-zero structure of A.
%
% Example: 
%    load graphs/dfs_example.mat
%    components(A)
%
% See also DMPERM, BICONNECTED_COMPONENTS

%
% David Gleich
% 21 April 2006
%

[trans check] = get_matlab_bgl_options(varargin{:});

if (check)
    % no additional input checks
    check_matlab_bgl(A,struct());
end;

if (trans)
    A = A';
end;

[ci sizes] = components_mex(A);


