function bc = betweenness_centrality(A,varargin)
% BETWEENNESS_CENTRALITY Compute the betweenness centrality for vertices.
%
% bc = betweenness_centrality(A) returns the betweenness centrality for
% all vertices in A.  
%
% This method works on weighted or weighted directed graphs.
% For unweighted graphs (options.unweighted=1), the runtime is O(VE).
% For weighted graphs, the runtime is O(VE + V(V+E)log(V)).
%
% ... = betweenness_centrality(A,options) sets optional parameters (see 
% set_matlab_bgl_options) for the standard options.
%   options.unweighted: use the slightly more efficient unweighted
%     algorithm in the case where all edge-weights are equal [{0} | 1]  
%
% Example:
%    load graphs/padgett-florentine.mat
%    betweenness_centrality(A)


[trans check] = get_matlab_bgl_options(varargin{:});

options = struct('unweighted', 0);
if (length(varargin) > 0)
    options = merge_structs(varargin{1}, options);
end;

if (check)
    % check the values
    if (options.unweighted ~= 1)
        check_matlab_bgl(A,struct('values',1));
    else
        check_matlab_bgl(A,struct());
    end;
end;

if (trans)
    A = A';
end;

unweighted = options.unweighted;
bc = betweenness_centrality_mex(A,unweighted);