function [d pred] = bellman_ford_sp(A,u,varargin)
% BELLMAN_FORD_SP Compute the weighted single source shortest path problem.
%
% The Bellman-Ford algorithm for the single source shortest path problem
% works on graphs with negative edge weights.  
%
% See the shortest_paths function for calling information.  This function 
% just calls shortest_paths(...,struct('algname','bellman_ford'));
%
% This method works on weighted directed graphs with negative edge weights.
% The runtime is O(VE).
%
% Example:
%    load graphs/kt-6-23.mat
%    d = bellman_ford_sp(A,1);
%
% See also SHORTEST_PATHS, DIJKSTRA_SP.

%
% David Gleich
% 23 April 2006
%

algname = 'bellman_ford';

if (nargin > 2)
    options = varargin{1};
    options.algname = algname;
else
    options = struct('algname',algname);
end;

[d pred] = shortest_paths(A,u,options);




