%% Experiment with a push-approach to computing Commute time
% Commute time ranking involves solving systems (ei-ej)L^+(ei-ej) for
% the laplacian matrix of a graph L

%% NOTE
% This experiment was a learning experiment, the consensus is that the
% approach failed.  
% See notes elsewhere, it is retained for completeness.

addpath('~/dev/mcode');
addpath('~/dev/gaimc');
%%
% Small starting graph from Jure's SNAP collection
A = readSMAT('ca-GrQc.smat');
A = A|A';
A = largest_component(A);
L = diag(sparse(sum(A))) - A;
n = size(A,1);
k = 50;
% randomly pick a set of k vertices and evaluate how many steps they take
verts = randperm(n);
verts1 = verts(1:k);
verts = randperm(n);
verts2 = verts(1:k);
for vi=1:k
    v1 = verts1(vi);
    v2 = verts2(vi);
    [x,r,hist,sverts] = commute_push(L,v1,v2);
    b = zeros(n,1); b(v1) = 1; b(v2) = -1;
    xtrue = (L)\b;
    xn = x-sum(x)/n;
    xtruen = xtrue-sum(xtrue)/n;
    fprintf('Steps: %6i; Edges: %8i; Time: %6.1f; Vertices: %6i; Err: %8.1e\n',...
        length(hist), hist(end,1), hist(end,end), sverts, norm(xn-xtruen)/norm(xtruen));
end

