%% 
% This script is just there to check the homebrew CG implementation
% copied from John Gilbert.  (No reason to doubt it's accuracy, but I
% wanted to validate a particular feature of the solutions and checking an
% independent implemenation was easy, so why not?)

%% load a graph
if ~exist('graphname','var') || ~exist('A','var')
    error('need to load a graph first another function');
end

%% normalize the graph
A = A|A';
A = A - diag(diag(A));
deg = sum(A,1)';
D = diag(sparse(deg));
L = D - A;
n = size(A,1);

%% Pick a vertex
vi = pairs_conv(1);
vj = pairs_conv(2);

%% Solve the system with minres
Ax = @(x) L*x + 1/n*sum(x);
ei = zeros(n,1);
ei(vi) = 1;
ej = zeros(n,1);
ej(vj) = 1;

[x,flag,relres,iter,resvec] = minres(Ax,ei-ej,1e-10,10000);
flag
cij = (ei-ej)' * x;

%% Get bounds from Golub-Meurant algorithm
[result bounds time] = commute_pairwise(A,vi,vj,1e-4,1000,1e-4);

%% Compare against homebrew CG
t0=tic;
[cijcg cg_hist cg_reshist] = commute_pairwise_cg(A,vi,vj,1e-4,1000);
dt=toc(t0);

%% Compare against Matlab's CG  modified for commute time
[x,flag,relres,iter,resvec,chist] = pcg_commute(Ax,ei-ej,1e-4,1000,vi,vj);

%% Plot a comparison
clf; hold on;
semilogy(abs(chist-cij)/abs(cij),'r.-'); 
semilogy(abs(cg_hist-cij)/abs(cij),'b-');
set(gca,'YScale','log');
legend('matlab pcg','commute pairwise cg');

%% result
% These two are