%% Plot results for pairwise Katz scores

%% Setup

addpath('../../matlab');
addpath('../../tools');
addpath('../');

setup_plot;

%% load a graph
if ~exist('graphname','var') || ~exist('A','var')
    error('need to load a graph first another function');
end
if ~exist('katz_alpha','var') || ~exist('katz_alpha_name','var')
    error('need to set Katz alpha values');
end
if ~exist('vpairname','var') || ~exist('vpair','var')
    error('need to set vpair');
end
%% Pick a vertex
vi = vpair(1);
vj = vpair(2);
%% Load results
filename = sprintf('katz-%s-%s-%i-%i',graphname,katz_alpha_name,vi,vj);
load(filename);

%% Plot
gmend = length(bounds);
bounds_err = abs(bounds-ktrue)/abs(ktrue);
neu_err = abs(neu_hist-ktrue)/abs(ktrue);
cg_err = abs(cg_hist-ktrue)/abs(ktrue);
semilogy(2:gmend,bounds_err(1,2:end),'k-',...
         2:gmend,bounds_err(2,2:end),'k-.',...
         2:length(neu_err),neu_err(2:end),'k--',...
         2:length(cg_err),cg_err(2:end),'k--');     
     
%%
% Just with CG
clf;
semilogy(2:length(cg_err),cg_err(2:end),'k-.',...
         4:2:2*gmend,bounds_err(1,2:end),'r-',...
         4:2:2*gmend,bounds_err(2,2:end),'b--');
legend('cg','lower bound','upper bound');
legend boxoff;
v = axis;
v(1) = 0;
axis(v);
title(sprintf('%s, Katz, %s',graphname, katz_alpha_name));
ylabel('relative error');
xlabel('matrix-vector products');
%%
box on;
greygrid;
set(gca,'Color','none'), set(gcf,'Color','none');
set(gcf, 'InvertHardCopy','off');
print([filename '-err.eps'],'-depsc2','-cmyk');

%%
% Show bound convergence
clf;
plot(2:length(cg_hist),cg_hist(2:end),'k-.',...
     4:2:2*gmend,bounds(1,2:end),'r-',...
     4:2:2*gmend,bounds(2,2:end),'r--');
legend('cg','lower bound','upper bound');
legend boxoff;
v = axis;
v(1) = 0;
axis(v);
title(sprintf('%s, Katz, %s alpha',graphname, katz_alpha_name));
ylabel('bounds');
xlabel('matrix-vector products');
%%
box on;
greygrid;
set(gca,'Color','none'), set(gcf,'Color','none');
set(gcf, 'InvertHardCopy','off');
print([filename '-bounds.eps'],'-depsc2','-cmyk');