function [final hist] = katz_pairwise_neumann(A,alpha,vi,vj,tol,maxiter)
% KATZ_NEUMANN Solve for the katz score with a Neumann series
% [kij hist] = katz_neumann(A,alpha,vi,vj,tol,maxiter)

% History
% :2010-06-23: Initial version 

n = size(A,1);

x = zeros(n,1);
x(vi) = 1;

hist = zeros(maxiter,1);

for iter=1:maxiter
    y = alpha*A*x;
    xres = x(vj);
    yres = y(vj);
    x = y;
    x(vi) = x(vi)+1;
    hist(iter) = x(vj);
    if abs(xres-yres)/max(abs(xres),abs(yres)) < tol
        break
    end
end
hist = hist(1:iter);
final = x(vj);