%% Compute results for pairwise Katz scores

%% Evaluate the accuracy of our push-approximation to the F-measure

addpath('../../matlab');
addpath('../../tools');

%% load a graph
if ~exist('graphname','var') || ~exist('A','var')
    error('need to load a graph first another function');
end
if ~exist('katz_alpha','var') || ~exist('katz_alpha_name','var')
    error('need to set Katz alpha values');
end
if ~exist('vpairname','var') || ~exist('vpair','var')
    error('need to set vpair');
end
%% normalize the graph
A = A|A';
A = A - diag(diag(A));
deg = sum(A,1)'; 
n = size(A,1);
B = speye(n) - katz_alpha*A;

%% Pick a vertex
vi = vpair(1);
vj = vpair(2);

%% Solve the system with minres
ei = zeros(n,1);
ei(vi) = 1;
[katz,flag,relres,iter,resvec] = minres(B,ei,1e-8,5000);
if flag ~= 0,
    error('minres did not converge');
end
ktrue = katz(vj);

%% Get bounds from Golub-Meurant algorithm
[result bounds time] = katz_pairwise(A,vi,vj,1e-4,katz_alpha,1e-4,1000);

%% Compare against Neumann series
t0=tic;
[kneu neu_hist] = katz_pairwise_neumann(A,katz_alpha,vi,vj,1e-6,1000);
neu_dt=toc(t0);
%%
% Eek, these results are really bad, I had to increase the precision
% to get it even close to the rest.

%% Compare against CG
t0=tic;
[kcg cg_hist] = katz_pairwise_cg(A,katz_alpha,vi,vj,1e-4,1000);
cg_dt=toc(t0);


%% Save results
filename = sprintf('katz-%s-%s-%i-%i',graphname,katz_alpha_name,vi,vj);

%%
save([filename '.mat'],'ktrue','flag','relres','iter','resvec','result',...
    'bounds','time','neu_dt','cg_dt','kneu','neu_hist','kcg','cg_hist');

