function [final,hist,resvec]=katz_pairwise_cg(A,alpha,vi,vj,tol,maxiter)
% KATZ_PAIRWISE_CG Estimate pairwise katz score with CG
% 
% [final,hist,resvec] = katz_pairwise_cg(A,alpha,vi,vj,tol,maxiter)
%
% Example:
%
% See also PAIRWISE_COMMUTE LAPLACIAN

% History
% :2010-06-24: Initial version based on code from John Gilbert
%

n = size(A,1);
b = zeros(n,1); b(vi) = 1;
B = speye(n) - alpha*A;

hist = zeros(maxiter,1);
resvec = zeros(maxiter,1);

x = zeros(n,1);
r = b;
rtr = r'*r;
d = r;
kijold = x(vj);

for iter=1:maxiter
    Ad = B*d;
    alpha = rtr / (d'*Ad);
    x = x + alpha * d;
    r = r - alpha * Ad;
    rtrold = rtr;
    rtr = r'*r;
    beta = rtr / rtrold;
    d = r + beta * d;
    kij = x(vj);
    
    % save history
    hist(iter) = kij;    
    resvec(iter) = norm(r);
    
    % check for convergence
    if abs(kij - kijold)/max(abs(kij),abs(kijold)) < tol || ...
       resvec(iter) < tol
        break;
    end
    kijold = kij;
end

final = kij;
hist = hist(1:iter);
resvec = resvec(1:iter);
