
%% Plot results for pairwise commute score convergence

%% Setup

addpath('../../matlab');
addpath('../../tools');
addpath('../');

setup_plot;

%% Evaluate the accuracy of our push-approximation to the F-measure

addpath('../../matlab');
addpath('../../tools');

%% load a graph
if ~exist('graphname','var') || ~exist('A','var')
    error('need to load a graph first another function');
end
if ~exist('vpairname','var') || ~exist('vpair','var')
    error('need to set vpair');
end
%% Pick a vertex
vi = vpair(1);
vj = vpair(2);
%% Load results
filename = sprintf('commute-%s-%i-%i',graphname,vi,vj);
load(filename);

%% Plot
clf;
gmend = length(bounds);
bounds_err = abs(bounds-cij)/abs(cij);
cg_err = abs(cg_hist-cij)/abs(cij);
semilogy(2:length(cg_err),cg_err(2:end),'k-.',...
         2:gmend,bounds_err(1,2:end),'r-',...
         2:gmend,bounds_err(2,2:end),'b--');
legend('cg','lower bound','upper bound');
set(gca,'yscale','log');
legend boxoff;
v = axis;
v(1) = 0;
axis(v);
title(sprintf('%s, Commute',graphname));
ylabel('relative error');
xlabel('matrix-vector products');
%%
box on;
greygrid;
set(gca,'Color','none'), set(gcf,'Color','none');
set(gcf, 'InvertHardCopy','off');
print([filename '-err.eps'],'-depsc2','-cmyk');

%%
% Show bound convergence
clf
semilogy(2:length(cg_hist),cg_hist(2:end),'k-.',...
     2:gmend,bounds(1,2:end),'r-',...
     2:gmend,bounds(2,2:end),'r--');
legend('cg','lower bound','upper bound');
legend boxoff;
v = axis;
v(1) = 0;
axis(v);
title(sprintf('%s, Commute',graphname));
ylabel('bounds');
xlabel('matrix-vector products');
%%
box on;
greygrid;
set(gca,'Color','none'), set(gcf,'Color','none');
set(gcf, 'InvertHardCopy','off');
print([filename '-bounds.eps'],'-depsc2','-cmyk');


