%% Results for pairwise commute-time scores

%% Evaluate the accuracy of our push-approximation to the F-measure

addpath('../../matlab');
addpath('../../tools');

%% load a graph
if ~exist('graphname','var') || ~exist('A','var')
    error('need to load a graph first another function');
end
if ~exist('vpairname','var') || ~exist('vpair','var')
    error('need to set vpair');
end
%% normalize the graph
A = A|A';
A = A - diag(diag(A));
deg = sum(A,1)';
D = diag(sparse(deg));
L = D - A;
n = size(A,1);

%% Pick a vertex
vi = vpair(1);
vj = vpair(2);

%% Set algorithm parameters
lmin = 1e-4;
gqtol = 1e-4;
exacttol = 1e-10;

%% Solve the system with minres
Ax = @(x) L*x + 1/n*sum(x);
ei = zeros(n,1);
ei(vi) = 1;
ej = zeros(n,1);
ej(vj) = 1;

[x,flag,relres,iter,resvec] = minres(Ax,ei-ej,exacttol,10000);
flag
cij = (ei-ej)' * x;

%% Get bounds from Golub-Meurant algorithm
[result bounds time] = commute_pairwise(A,vi,vj,gqtol,1000,lmin);

%% Compare against homebrew CG
t0=tic;
[cijcg cg_hist cg_reshist] = commute_pairwise_cg(A,vi,vj,gqtol,1000);
cg_dt=toc(t0);

%% Save results
filename = sprintf('commute-%s-%i-%i',graphname,vi,vj);

%%
save([filename '.mat'],'cij','flag','relres','iter','resvec','result',...
    'bounds','time','cg_dt','cijcg','cg_hist','cg_reshist',...
    'vpair','vpairname','lmin','gqtol','exacttol');

