function [final,hist,resvec]=commute_pairwise_cg(A,vi,vj,tol,maxiter)
% COMMUTE_PAIRWISE_CG Estimate pairwise commute time with CG
% 
% [final,hist,resvec] = commute_pairwise_cg(A,vi,vj,tol,maxiter)
%
% Example:
%
% See also PAIRWISE_COMMUTE LAPLACIAN

% History
% :2010-06-24: Initial version based on code from John Gilbert
%



n = size(A,1);
ei = zeros(n,1); ei(vi) = 1;
ej = zeros(n,1); ej(vj) = 1;
b = ei - ej;
L = laplacian(A);

hist = zeros(maxiter,1);
resvec = zeros(maxiter,1);

normb = norm(b);
x = zeros(n,1);
r = b;
rtr = r'*r;
d = r;
cijold = x(vi)-x(vj);

for iter=1:maxiter
    Ad = L*d + 1/n*sum(d);
    alpha = rtr / (d'*Ad);
    x = x + alpha * d;
    r = r - alpha * Ad;
    rtrold = rtr;
    rtr = r'*r;
    beta = rtr / rtrold;
    d = r + beta * d;
    cij = x(vi)-x(vj);
    
    % save history
    hist(iter) = cij;    
    resvec(iter) = norm(r);
    
    % check for convergence
    if resvec(iter) < tol
        break;
    end
    cijold = cij;
end

final = cij;
hist = hist(1:iter);
resvec = resvec(1:iter);
