%% Setup data for the other netflix experiments

addpath('../../matlab');


% load the data
A = readSMAT('/var/tmp/dgleich/data/netflix/netflix.smat');

% form the bipartite graph 
B = spaugment(A);
subset = (1:size(B,1));

% save it to make loading things faster
save('netflix-full.mat','B','subset','-v7.3');

B = spfun(@(x) x>=4, B);

addpath('~/dev/gaimc/');
[B,subset] = largest_component(B);
save('netflix-full-4.mat','B','subset','-v7.3');

% load the names
movies = textread('/var/tmp/dgleich/data/netflix/netflix.movies',...
            '%s', 'delimiter', '\n','bufsize',16383);
save('netflix-movies.mat', 'movies');


