%% Netflix 

addpath('../../matlab');

% load movies
load('netflix-movies');

% load the smaller dataset (creates B)
load('netflix-full-4');

% compute user nodes and movie nodes
% the movie nodes are the first 1:length(movies) nodes
nallmovies = length(movies);
mnodes = subset(subset<=nallmovies); % the set of movie nodes
unodes = subset(subset>nallmovies); % the set of user nodes
nmovies = length(mnodes);
nusers = length(unodes);

%% Perform a hold-out test

nheld = 100;
% find the non-zeros
[nzi,nzj] = find(B);
% select nheld entries
% but not actually random...
rs = RandStream.create('mt19937ar');
randnz = randi(rs,length(nzi),nheld,1);
fprintf('Found %i unique entries for %i samples (these values should be equal)\n', ...
  length(unique(randnz)), nheld);
holdouts = [nzi(randnz) nzj(randnz)];

% run the holdout experiments
deg = sum(B,2);
ranks = [];
for i=1:nheld
  holdi = holdouts(i,1);
  holdj = holdouts(i,2);
  % reverse the order for simplicity
  if holdi<holdj, holdi=holdouts(i,2); holdj=holdouts(i,1); end
  B2 = B;
  B2(holdi,holdj) = 0;
  B2(holdj,holdi) = 0;
  deg2 = deg;
  deg2(holdi) = deg2(holdi) - 1;
  deg2(holdj) = deg2(holdj) - 1;
  fprintf('Computing hold-out for (%i,%i) ...\n', holdi, holdj);
  %return;
  [x,r,hist,nverts] = Lp_push_markov_mex(B2,holdi,1,5/size(B,1),10000);
  ct = -(deg2.*x + (1./deg2).*x);
  [ignore neighs] = find(B2(holdi,:));
  ct(neighs) = max(ct);
  [ignore perm] = sort(ct);
  rank = nnz(ct<ct(holdj));
  ranks(i) = rank;
  fprintf('  ... time=%5.1s, verts=%6i, steps=%6i, rank=%4i\n',...
    hist(4,end), nverts, length(hist), rank);
end



