%% Netflix 

addpath('../../matlab');

% load movies
load('netflix-movies');

% load the smaller dataset (creates B)
load('netflix-full-4');

% compute user nodes and movie nodes
% the movie nodes are the first 1:length(movies) nodes
nallmovies = length(movies);
mnodes = subset(subset<=nallmovies); % the set of movie nodes
unodes = subset(subset>nallmovies); % the set of user nodes
nmovies = length(mnodes);
nusers = length(unodes);

%% Perform a cross-validation test

nsets = 10;
% find the non-zeros (upper triangular only)
[nzi,nzj] = find(triu(B));
% select nheld entries
% but not actually random...
rs = RandStream.create('mt19937ar');
entries = randperm(rs,length(nzi))';
xvals = cell(nsets,1);
sizes = [floor(length(nzi)/nsets) + double(mod(length(nzi),nsets)>(0:nsets-1))];
splits = cumsum([1 sizes]);
% each set is randperm(splits(i):(splits(i+1)-1))

for i=1:nsets
  entries = randperm(splits(i):(splits(i+1)-1));
  othernz = 1:length(nzi);
  othernz(entries) = 0;
  V1 = sparse(nzi(entries),nzj(entries),1,size(B,1),size(B,2));
  A1 = sparse(nzi(othernz),nzj(othernz),1,size(B,1),size(B,2));
  B1 = B1 + B1';
  xvals{i} = {B1,V1};
end

%% Run the cross validation experiment
maxpred = 500;
for i=1:nsets
  B1 = xvals{i}{1};
  V1 = xvals{i}{2};
  [vi,vj] = find(V1);
  missing_users = unique(vj);
  fprintf('Cross-validation set %i: predicting %i users\n',...
    i, length(missing_users));
  %[x,r,hist,nverts] = Lp_push_markov_mex(B1,holdi,1,5/size(B,1),10000);
end
