%% Compute the minimum eigenvalue for our linear systems

datadir = '../data';
graphs = {'arxiv_lcc.mat','dblp_lcc.mat','flickr2.mat'};
addpath('../matlab');

%%
for gi=1:length(graphs)
    load(fullfile(datadir,graphs{gi}));
    n = size(A,1);
    B = speye(n) - katz_alpha_hard*A;
    L = laplacian(A);
    [Vk,Dk,flagk] = eigs(B,10,'SA');
    [Vc,Dc,flagc] = eigs(L,5,'SA',struct('maxit',50000,'p',50));
    results(gi).graph = graphs{gi};
    results(gi).alpha = katz_alpha_hard;
    results(gi).katz_eig = diag(Dk);
    results(gi).commute_eig = diag(Dc);
    results(gi).katz_flag = flagk;
    results(gi).commute_flag = flagc;
    results
    save 'lambda_min.mat' results
end
