%% Results for top-k in the Katz measure

%% Evaluate the accuracy of our push-approximation to the F-measure

addpath('../../matlab');
addpath('../../tools');

%%
graphs = {'arxiv_lcc','dblp_lcc','flickr2'};
alphas = {'easy','med','hard','diffuse'};
pairs = {'conv','high_degree','low_degree'};
results = [];
ri = 1;
nstep = 5e6;
%%
for gi=1:length(graphs)
    %%
    graphname = graphs{gi};
    load(['../../data/' graphname]);
    % normalize the graph
    A = A|A';
    A = A - diag(diag(A));
    deg = sum(A,1)'; 
    n = size(A,1);
    for ai = 1:length(alphas)
        %%
        alpha_name = alphas{ai};
        if strcmp(alpha_name,'diffuse')
            alpha = Inf;
        else
            alpha = eval(['katz_alpha_' alpha_name]);
        end
        for pi = 1:length(pairs)
            %%
            pair_name = pairs{pi};
            pair = eval(['pairs_' pair_name]);
            vert = pair(2);
            if isfinite(alpha)
                [kp,r,hist,nverts] = katz_push_mex(A,alpha,vert,...
                    1e-4*(alpha*deg(vert)),nstep);
            else
                [kp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1,3/n,nstep);
            end
            results(ri).dt = hist(4,end);
            results(ri).nverts = nverts;
            results(ri).nedges = hist(1,end);
            results(ri).alpha = alpha;
            results(ri).alpha_name = alpha_name;
            results(ri).graph = graphname;
            results(ri).resid = hist(2,end);
            results(ri).nsteps = size(hist,2);
            results(ri).resid_norm = norm(r);
            results(ri).pair = pair_name;
            results(ri).vert = vert;
            results(ri).index = [gi,ai,pi];
            results(ri)
            ri=ri+1;
        end
    end
end
save('topk-runtime.mat','results','alphas','graphs','pairs');
        
%% Convert the results into a table
Times = zeros(length(graphs),length(alphas),length(pairs));
Steps = Times;
Nverts = Times;
Nedges = Times;
for ri=1:length(results)
    sub = num2cell(results(ri).index);
    ind = sub2ind(size(Times),sub{:});
    Times(ind) = results(ri).dt;
    Steps(ind) = results(ri).nsteps;
    Nverts(ind) = results(ri).nverts;
    Nedges(ind) = results(ri).nedges;
end
%% Print the results as a table
depth = 2;
% print the alpha header
for di = 1:depth
    fprintf('%10s & ', '');
end
for ai = 1:length(alphas)
    if ai>1, fprintf(' & '); end
    fprintf('%10s ', alphas{ai});
end
fprintf(' \\\\ \n');
for gi=1:length(graphs)
    fprintf('%10s & ', graphs{gi});
    for pi=1:length(pairs)
        if pi>1
            for di = 1:depth-1
                fprintf('%10s & ', '');
            end
        end
        fprintf('%10s & ', pairs{pi});
        for ai=1:length(alphas)
            if ai>1, fprintf(' & '); end
            fprintf('%10.4f ', Times(gi,ai,pi));
        end
        fprintf(' \\\\ \n');
    end
end
            
            