%% Try computing hitting time

addpath('../../matlab');

%% Real world graph
A = readSMAT('../../data/stanford-cs-sym.smat');
n = size(A,1);

%% Normalize
deg = sum(A,1);
P = diag(1./deg)*A;
D = diag(deg);
L = D-A;

%% Hitting time computation 
% From Telati [1999]
stat = deg./sum(deg);
Pbar = diag(stat(1:n-1)) -diag(stat(1:n-1))*P(1:n-1,1:n-1);
%% 
% Check against the Laplacian
Lbar = L(1:n-1,1:n-1);
norm(Lbar/sum(deg) - Pbar,'fro')
%%
Hbar = inv(Pbar);
Hin = Hbar*stat(1:n-1)';
H = zeros(n);
H(1:n-1,n) = Hbar*stat(1:n-1)';
H(n,1:n-1) = diag(Hbar) - Hbar*stat(1:n-1)';
H(1:n-1,1:n-1) = -Hbar + Hbar*stat(1:n-1)'*ones(1,n-1) + ones(n-1,1)*(diag(Hbar) - Hbar*stat(1:n-1)')';
CH = H+H'; % Commute time from hitting time
%% Check commute time
% Check against the pseudo-inverse of the Laplacian
Lp = pinv(full(L)); % just compute the pseudo-inverse
%%
% build commute time column-by-column... todo: find a matrix way
C = zeros(n);
for i=1:n
    C(:,i) = diag(Lp) + Lp(i,i) - 2*Lp(:,i);
end
norm(C*sum(sum(A))-CH,1)/sum(sum(A)) % look at a relative residual

%% Summary
% The system above is L^{-1} e_i for the HITTING time.
% the solution is then combined from that.  Let's see how close we can get.

%% Use a different system for the hitting time
pP = pinv(eye(n)-P);
%%
Hunscaled = pP*(ones(n)-eye(n));
%Hunscaled = pP*(ones(n));
%dH = diag(Hunscaled);
%H2 = Hunscaled - ones(n,1)*dH';
H2 = Hunscaled;
%%
% Look at the residual
HR = ones(n) - (eye(n) - P)*H;
HR(1:10,1:10)
%HR = HR - diag(diag(HR));
norm(HR,1)

%% Try and estimate this more quickly
% Now we are going to try and get a fast estimate of the hitting
% time for a single row.  We can ALMOST get it from a single solve with
% Lbar, but then we need the adjustment Lbar^{-1}*stationary, which means
% we'd have to solve a dense system.  We are going to investigate
% approximations to Lbar^{-1}*e

%% Solve a single system in L
Lbar = L(1:n-1, 1:n-1);
%%
i = 100;
ei = zeros(n-1,1);
ei(i) = 1;
li = Lbar\ei;
plot(H(i,1:n-1),li,'b.',H(1:n-1,i),li,'r.');
%% 
% The key quantity in the adjustment is Lbar^{-1} * stationary, is that
% nice?
ai = Lbar\stat(1:n-1)';
plot(ai,1./deg(1:n-1),'.');
%%
% ai = (I-P)^{-1} e
% which doesn't seem to be anything....
y = (speye(n-1)-P(1:n-1,1:n-1))\ones(n-1,1);
plot(y,deg,'.');
%%
% Try estimating with the Neumann series
z = ones(n-1,1);
for i=1:200
    z = ones(n-1,1) + P(1:n-1,1:n-1) *z;
end
plot(z,y,'.');
%% 
% Try the adjustement
%hi = -li +stat(1:n-1)* li + li(i);
%plot(H(i,1:n-1),hi,'b.',H(1:n-1,i),hi,'r.');


