%% Quick experiment with damping functions
% These functions control the decay of omega=1 to omegabar = (omega
% such that residual=1/n).

%% Function 1:
%   1-N/steps*(visited - 1)*(1-omegabar)

f = @(visited,steps,N,omegabar) 1-(N/steps)*(visited-1)*(1-omegabar);
steps = 1e4;
N = 1000;
omegabar = 0.02;
fplot(@(x) f(x,steps,N,omegabar),[1 ceil(steps/N)+1]);

