%% Evaluate approximations to commute time
% We construct a random graph on n nodes with expected degree d;
% and compute the pseudo-inverse of its Laplacian for an exact answer

%% Construct a random graph
rand('state',0); % ensure repeatability
n = 1000;
d = 10;
A = sprandsym(n,d/n);
A = spones(A);

%% Consruct a mesh
A = spones(delsq(numgrid('S',32)));
n = size(A,1);

%% Real world graph
A = readSMAT('../../data/stanford-cs-sym.smat');
n = size(A,1);

%% Compute the pseudo-inverse
D = diag(sum(A,1)');
L = D-A;
Lp = pinv(full(L)); % just compute the pseudo-inverse

%%
% Commute times are 
% (ei-ej)L^+(ei-ej)
% so for a given column/row, it's
% Lp(i,i) + diag(Lp) - 2*Lp(:,ei) = 
% 

% A quick check
c56 = Lp(5,5) + Lp(6,6) - 2*Lp(5,6);
v5 = diag(Lp) + Lp(5,5) - 2*Lp(:,5);

%% Compare commute times with values in Lp
% build commute time column-by-column... todo: find a matrix way
C = zeros(n);
for i=1:n
    C(:,i) = diag(Lp) + Lp(i,i) - 2*Lp(:,i);
end
%%
% build an approximate commute time with just Lp(i,i) - 2*Lp(:,i)
aC = zeros(n);
for i=1:n
    aC(:,i) = Lp(i,i) - 2*Lp(:,i);
end
aC = aC - diag(diag(aC));
%% 
% Plot the correspondence
plot(aC(:),C(:),'.');
xlabel('approximate commute time');
ylabel('commute time');
%%
% But that doesn't tell the whole story, we need everything relative to
% a particular node 
for i=1:15
    subplot(3,5,i)
    plot(aC(:,i),C(:,i),'.');
    xlabel('approximate commute time');
    ylabel('commute time');
end
%%
% Same plot, but with ranks in terms of commute times
for i=1:15
    subplot(3,5,i)
    [ignore p1] = sort(C(:,i));
    [ignore p2] = sort(aC(:,i));
    ip1(p1) = 1:length(p1);
    ip2(p2) = 1:length(p2);
    loglog(ip1,ip2,'.');
    xlabel('approximate commute time');
    ylabel('commute time');
end
%% 
% Okay, so our approximate commute time measure is garbage with respect to
% actual commute time.  Perhaps it'd be better on larger graphs?  I guess
% we could check a region... who knows.

%% 
% We also have another approximate commute time method -- approx_commute,
% lets see how that stacks up.
for i=1:15
    subplot(3,5,i)
    aC = approx_commute(L,i);
    plot(aC,C(:,i),'.'); drawnow;
    xlabel('approximate commute time');
    ylabel('commute time');
end




