%% Test relationship between commute time and hitting time

addpath('../../matlab');

%% Real world graph
A = readSMAT('../../data/stanford-cs-sym.smat');
n = size(A,1);

%% Compute the pseudo-inverse
D = diag(sum(A,1)');
L = D-A;
Lp = pinv(full(L)); % just compute the pseudo-inverse
Ct = zeros(n);
for i=1:n
    for j=1:n
        Ct(i,j) = Lp(i,i) + Lp(j,j) - 2*Lp(i,j);
    end
end

%% Compute the Markov matrix and reverse Markov matrix
deg = sum(A,1);
P = diag(1./deg)*A;
stationary = deg./sum(deg);
R = diag(1./stationary)*P'*diag(stationary);

%% Try computing a few quantities for an example problem
i = 100;
ei = zeros(n,1); ei(i) = 1;
e = ones(n,1);
B = (speye(n) - P);
C = (e*stationary./n);
D = (B-C);
%% Test with globalization
xg = (B-C)\(e- ei) + C*(e- ei);
yg = (B-C)'\(e- ei) + C'*(e- ei);
plot(Ct(:,i),xg+yg,'.');
%% Test without the globalization
xl = (B-C)\(ei) + C*(ei);
yl = (B-C)'\(ei) + C'*(ei);
plot(Ct(:,i),xl+yl,'.');

%% Solution of just the globalization portion
xlg = (B-C)\(e) + (C)*(e);
ylg = (B-C)'\(e) + (C)'*(e);
plot(xlg,'.');
plot(ylg,deg,'.');
%%
% So xlg is just a constant = 1
% ylg is proportional to the degree.... not sure about scaling yet though.

%% Adjust the non-globalized solution
% Formal adjustment
plot(Ct(:,i),xlg-xl+ylg-yl,'.');
%%
% Heuristic adjustment
plot(Ct(:,i),1-xl+ylg-yl,'.');

%% Try this on the PageRank chain
i = 100;
ei = zeros(n,1); ei(i) = 1;
e = ones(n,1);
alpha = 0.99;
B = (speye(n) - alpha*P - (1-alpha));
C = 0;

%% Test with globalization
xg = (B-C)\(e- ei) + C*(e- ei);
yg = (B-C)'\(e- ei) + C'*(e- ei);
plot(Ct(:,i),xg+yg,'.');
%% Test without the globalization
xl = (B-C)\(ei) + C*(ei);
yl = (B-C)'\(ei) + C'*(ei);
plot(Ct(:,i),xl+yl,'.');

%% Solution of just the globalization portion
xlg = (B-C)\(e) + (C)*(e);
ylg = (B-C)'\(e) + (C)'*(e);
plot(xlg,'.');
plot(ylg,deg,'.');
%%
% Heuristic adjustment
loglog(Ct(:,i),n-xl+n*deg'-yl,'.');