%% Evaluate push-approximations to commute time
% For a real-world graph, we evaluate push algorithms to compute
% commute times.  

addpath('../../matlab');
%% Real world graph
A = readSMAT('../../data/stanford-cs-sym.smat');
n = size(A,1);
deg = sum(A,1)';

%% Compute the pseudo-inverse
D = diag(sum(A,1)');
L = D-A;
Lp = pinv(full(L)); % just compute the pseudo-inverse
P = diag(1./deg)*A;


%% Compare commute times with values in Lp
% build commute time column-by-column... todo: find a matrix way
C = zeros(n);
for i=1:n
    C(:,i) = diag(Lp) + Lp(i,i) - 2*Lp(:,i);
end


%%
% Current best, formed by converting 
% (I-P)x = ei, (I-P')x = ei into solves with the Laplacian.
T = zeros(n);
for i=1:n
    T(:,i) =  -(deg.*Lp(:,i) + (1./deg).*Lp(:,i));
end 


%% Pick a set of random nodes and plot the precision
% The idea is that you run ONE of the various approximations above
% and show it's performance with this section.  
nnodes = 200;
rand('state',0);
randnodes = randperm(n);
nodes = randnodes(1:nnodes);
ks = [5:5:50];
precisions = zeros(nnodes, length(ks));
for ni=1:nnodes
    curn = nodes(ni);
    [x,r,hist,nverts] = Lp_push_markov_mex(A,curn,1.01,1e-5,20*nnz(A));
    fprintf('curn:%7i   steps: %8i; nverts: %6i\n', curn, length(hist), nverts);
    %t = -(deg.*x + (1./deg).*x);
    t = -(deg.*x + (deg(curn)).*x);
    %[ignore pL] = sort(T(:,curn));
    [ignore pL] = sort(t);
    [ignore pC] = sort(C(:,curn));
    for ki=1:length(ks)
        k = ks(ki);
        precisions(ni,ki) = length(intersect(pL(1:k),pC(1:k)))/k;
    end
end
% Plot mean average precisions
%plot(ks,mean(precisions))
boxplot(precisions,'labels',ks)
ylim([-0.1,1.1])


%% 
% We also have another approximate commute time method -- approx_commute,
% lets see how that stacks up.
for i=1:15
    subplot(3,5,i)
    aC = approx_commute(L,i);
    plot(aC,C(:,i),'.'); drawnow;
    xlabel('approximate commute time');
    ylabel('commute time');
end




