%% Evaluate approximations to commute time
% For a real-world graph, we see how close the elements of the Laplacian
% pseudo-inverse are to inverse commute time.

addpath('../../matlab');
%% Real world graph
A = readSMAT('../../data/stanford-cs-sym.smat');
n = size(A,1);
deg = sum(A,1)';

%% Compute the pseudo-inverse
D = diag(sum(A,1)');
L = D-A;
Lp = pinv(full(L)); % just compute the pseudo-inverse
P = diag(1./deg)*A;


%% Compare commute times with values in Lp
% build commute time column-by-column... todo: find a matrix way
C = zeros(n);
for i=1:n
    C(:,i) = diag(Lp) + Lp(i,i) - 2*Lp(:,i);
end

%% Setup differnt test scenarios
T = zeros(n);
for i=1:n
    T(:,i) =  Lp(i,i) - 2*Lp(:,i);
end

%%
T = -Lp;
%%
% Current best, formed by converting 
% (I-P)x = ei, (I-P')x = ei into solves with the Laplacian.
T = zeros(n);
for i=1:n
    T(:,i) =  -(deg.*Lp(:,i) + (1./deg).*Lp(:,i));
end 
%%
% Real solution to the above
T = zeros(n);
for i=1:n
    T(:,i) =  -(deg.*Lp(:,i) + deg(i).*Lp(:,i));
end 

%%
% 
% T = zeros(n);
% for i=1:n
%     T(:,i) =  n./deg -(deg.*Lp(:,i) + (1./deg).*Lp(:,i));
% end 


%%
Pp = pinv(speye(n)-P);
%%
%T = -(Pp + Pp');
%%
%T = -(Pp)';
%%
%T = -(Pp - (1./sum(A,1)')*ones(1,n));
%%
%T = ((n./sum(A,1)')*ones(1,n));
%%
%T = -(Pp + Pp' - (1./sum(A,1)')*ones(1,n));
%%
%T = -(Pp + Pp' + sum(A,1)'*ones(1,n));

%%
Pp1 = inv(speye(n)-P-1);
%%
%T = -(Pp1 + Pp1');

%%
%Pp2 = inv(speye(n)-0.99*P);
%%
%T = -(Pp2 + Pp2');
%%
%T = -(diag(deg)*Pp2 + diag(1./deg)*Pp2');

%% Pick a set of random nodes and plot the precision
% The idea is that you run ONE of the various approximations above
% and show it's performance with this section.  
nnodes = 300;
rand('state',0);
randnodes = randperm(n);
nodes = randnodes(1:nnodes);
ks = [5:5:50];
precisions = zeros(nnodes, length(ks));
for ni=1:nnodes
    curn = nodes(ni);
    [ignore pL] = sort(T(:,curn));
    [ignore pC] = sort(C(:,curn));
    for ki=1:length(ks)
        k = ks(ki);
        precisions(ni,ki) = length(intersect(pL(1:k),pC(1:k)))/k;
    end
end
% Plot mean average precisions
%plot(ks,mean(precisions))
boxplot(precisions,'labels',ks)
ylim([-0.1,1.1])


%% Pick a set of random nodes and plot the precision (without the neighbors)
% The idea is that you run ONE of the various approximations above
% and show it's performance with this section.  
nnodes = 300;
rand('state',0);
randnodes = randperm(n);
nodes = randnodes(1:nnodes);
ks = [5:5:50];
precisions = zeros(nnodes, length(ks));
for ni=1:nnodes
    curn = nodes(ni);
    t = T(:,curn);
    c = C(:,curn);
    t(A(curn,:)>0) = max(t);
    c(A(curn,:)>0) = max(c);
    [ignore pL] = sort(t);
    [ignore pC] = sort(c);
    for ki=1:length(ks)
        k = ks(ki);
        precisions(ni,ki) = length(intersect(pL(1:k),pC(1:k)))/k;
    end
end
% Plot mean average precisions
%plot(ks,mean(precisions))
boxplot(precisions,'labels',ks)
ylim([-0.1,1.1])

