%% Lp_push tolerance
% investigate tolerance and accuracy in the Lp_push codes
addpath('../../matlab');
addpath('~/dev/gaimc');

%%
graphs = {'../../data/stanford-cs-sym.smat' ...
          '../../data/as20000102.smat' ...
          '../../data/wiki-Vote.smat' ...
          '../../data/ca-AstroPh.smat'};
      
for gi = 1:length(graphs) 
    %% Load the graph
    % We start with a small graph, with coordinates
    graph = graphs{gi}
    A = readSMAT(graph);
    A = A|A';
    A = A - diag(diag(A));
    A = largest_component(A);
    deg = sum(A,1);
    D = diag(sparse(deg));
    L = D - A;
    P = diag(sparse(1./deg))*A;
    n = size(A,1);

    %% Pick a vertex
    vert = 1;
    ei = zeros(n,1);
    ei(vert) = 1;
    
    %% Solve the system with minres
    Ax = @(x) L*x - 1/n*sum(x);
    [x,flag,relres,iter,resvec] = minres(Ax,ei,1e-8,5000);

    %% Check permissible levels of accuracy
    % we know that ||r,1|| is bounded above by 1, thus, ||r,inf|| is bounded
    % below by 1/n.  Thus, reasonable tolerances range between 2/n to 10/n
    [ignore p] = sort(x,'descend');

    for tol = [10 5 3 2.5 2.25 2.1 2 1.95]
        [xp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1,tol/size(A,1),50*nnz(A));
        hist = hist';
        nsteps = length(hist);
        [ignore pp] = sort(xp,'descend');
        p100 = length(intersect(pp(1:100),p(1:100)));
        fprintf('tol: %5.2f  nverts: %6i  steps/nnz: %4.1f  p@100: %3i\n', ...
            tol, nverts, nsteps/nnz(A), p100);
    end
    
    %% Check extreme accuracy
    % we know that ||r,1|| is bounded above by 1, thus, ||r,inf|| is bounded
    % below by 1/n.  Thus, reasonable tolerances range between 2/n to 10/n
    [ignore p] = sort(x,'descend');
    
    [xp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1,1/size(A,1),100*nnz(A));
    hist = hist';
    nsteps = length(hist);
    [ignore pp] = sort(xp,'descend');
    p100 = length(intersect(pp(1:100),p(1:100)));
    fprintf('tol: -----  nverts: %6i  steps/nnz: %4.1f  p@100: %3i\n', ...
        nverts, nsteps/nnz(A), p100);

end