%% Test the accuracy of the Lp_push_markov algorithm
% To test the accuracy of our Lp_push_markov function, we check
% it against a solution from an iterative method on a few graphs.

addpath('../../matlab');

%% Load the graph
% We start with a small graph, with coordinates
A = readSMAT('../../data/tapir.smat');
A = A|A';
A = A - diag(diag(A));
xy = load('../../data/tapir.xy');
deg = sum(A,1);
D = diag(sparse(deg));
L = D - A;
P = diag(sparse(1./deg))*A;
n = size(A,1);
NL = speye(n) - diag(sparse(1./sqrt(deg)))*A*diag(sparse(1./sqrt(deg)));
%% Pick a vertex
vert = 1;
ei = zeros(n,1);
ei(vert) = 1;
%% Solve the system with minres
Ax = @(x) L*x - 1/n*sum(x);
[x,flag,relres,iter,resvec] = minres(Ax,ei,1e-8,5000);

% %% Do a silly test for my own edification
% % It seems like minres takes forever to converge on these systems, so I
% % want to see what happens with a vector actually in the range-space.
% eij = ei;
% eij(vert+1) = -1;
% [x,flag,relres,iter,resvec] = minres(Ax,eij,1e-5,5000);
% plot(resvec);
% 

%% Check that it solves the Markov system
y = D*x;
norm(ei-(speye(n) - P')*y+mean(D\y),1)

%% Solve the system with our push algorithm
[xp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1.001,1/size(A,1),300*nnz(A));
%[xp,r,hist,nverts]
[ignore,p] = sort(xp);
subplot(1,2,1);
plot(x(p),'.');
subplot(1,2,2);
plot(x,xp-mean(xp),'.');

%% Try the normalized solution
%[xpn,r,hist,nverts] = Lp_push_normalized(A,vert,1,1/size(A,1),5*nnz(A));
% the normalized solution doesn't behave any differently (no surprise)
% so we ignore it.

%% Check permissible levels of accuracy
% we know that ||r,1|| is bounded above by 1, thus, ||r,inf|| is bounded
% below by 1/n.  Thus, reasonable tolerances range between 2/n to 10/n
[ignore p] = sort(x,'descend');

for tol = [10 5 3 2.5 2 1.75 1.5 1.25]
    [xp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1.1,tol/size(A,1),50*nnz(A));
    hist = hist';
    nsteps = length(hist);
    [ignore pp] = sort(xp,'descend');
    p100 = length(intersect(pp(1:100),p(1:100)));
    fprintf('tol: %5.2f  nverts: %6i  steps/nnz: %4.1f  p@100: %3i\n', ...
        tol, nverts, nsteps/nnz(A), p100);
end


%%
[xp,r,hist,nverts] = Lp_push_markov_mex(A,vert,1.1,1/size(A,1),1500*nnz(A));

%% Load a web-graph
A = readSMAT('../../data/stanford-cs-sym.smat');