%% Add extra info to the mat files

%% Arxiv
clear;
load('arxiv_lcc');
A=double(A|A');
pairs_conv = [47160,532];
pairs_low_degree = [532,1222];
pairs_high_degree = [47160,50380];
katz_alpha_hard = 1./(max(svds(A))+1);
katz_alpha_med = 1./max(sum(A)+1);
katz_alpha_easy = 0.1*katz_alpha_med;
save('arxiv_lcc','A','pairs*','katz_alpha_*');

%% Dblp
clear;
load('dblp_lcc');
A=double(A|A');
pairs_conv = [62780,1948];
pairs_low_degree = [1948,2570];
pairs_high_degree = [62780,1948];
katz_alpha_hard = 1./(max(svds(A))+1);
katz_alpha_med = 1./max(sum(A)+1);
katz_alpha_easy = 0.1*katz_alpha_med;
save('dblp_lcc','A','pairs*','katz_alpha_*');

%% Flickr2
clear;
load('flickr2');
A=double(A|A');
pairs_conv = [9206,61709];
pairs_low_degree = [61709,714];
pairs_high_degree = [9206,3844];
katz_alpha_hard = 1./(max(svds(A))+1);
katz_alpha_med = 1./max(sum(A)+1);
katz_alpha_easy = 0.1*katz_alpha_med;
save('flickr2','A','pairs*','katz_alpha_*');