/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Long2ObjectOpenHashMap<V>
extends AbstractLong2ObjectMap<V>
implements Serializable,
Cloneable,
Hash {
    protected transient long[] key;
    protected transient V[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Long2ObjectMap.FastEntrySet<V> entries;
    protected volatile transient LongSet keys;
    protected volatile transient ObjectCollection<V> values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Long2ObjectOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new long[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
    }

    public Long2ObjectOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Long2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2ObjectOpenHashMap(Map<? extends Long, ? extends V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2ObjectOpenHashMap(Map<? extends Long, ? extends V> m) {
        this(m, 0.75f);
    }

    public Long2ObjectOpenHashMap(Long2ObjectMap<V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2ObjectOpenHashMap(Long2ObjectMap<V> m) {
        this(m, 0.75f);
    }

    public Long2ObjectOpenHashMap(long[] k, V[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2ObjectOpenHashMap(long[] k, V[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public V put(long k, V v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            V oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Long ok, V ov) {
        V v = ov;
        long k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            V oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == null ? v == null : value[i].equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.value, null);
    }

    @Override
    public boolean containsKey(long k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public V get(long k) {
        int i = this.findKey(k);
        return (V)(i < 0 ? this.defRetValue : this.value[i]);
    }

    @Override
    public V remove(long k) {
        int i = this.findKey(k);
        if (i < 0) {
            return (V)this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        V v = this.value[i];
        this.value[i] = null;
        return v;
    }

    public V get(Long ok) {
        int i = this.findKey(ok);
        return (V)(i < 0 ? this.defRetValue : this.value[i]);
    }

    @Override
    public V remove(Object ok) {
        int i = this.findKey((Long)ok);
        if (i < 0) {
            return (V)this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        V v = this.value[i];
        this.value[i] = null;
        return v;
    }

    public Long2ObjectMap.FastEntrySet<V> long2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Long2ObjectOpenHashMap.this.count;
                }

                @Override
                public boolean contains(Object v) {
                    return Long2ObjectOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Long2ObjectOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        long[] key = this.key;
        long[] newKey = new long[newN];
        V[] value = this.value;
        Object[] newValue = new Object[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            long k = key[i];
            V v = value[i];
            int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Long2ObjectOpenHashMap c;
        try {
            c = (Long2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = HashCommon.long2int(this.key[i]);
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : this.value[i].hashCode();
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeLong(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new long[n];
        long[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            long k = s.readLong();
            Object v = s.readObject();
            int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Long2ObjectOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        public LongIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Long2ObjectOpenHashMap.this.count;
        }

        public boolean contains(long k) {
            return Long2ObjectOpenHashMap.this.containsKey(k);
        }

        public boolean remove(long k) {
            int oldCount = Long2ObjectOpenHashMap.this.count;
            Long2ObjectOpenHashMap.this.remove(k);
            return Long2ObjectOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Long2ObjectOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Long2ObjectOpenHashMap.this.key[this.nextEntry()];
        }

        public Long next() {
            return Long2ObjectOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Long2ObjectMap.Entry<V>>
    implements Long2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Long2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Long2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Long2ObjectOpenHashMap.this.findKey((Long)e.getKey());
            return i >= 0 && (Long2ObjectOpenHashMap.this.value[i] == null ? e.getValue() == null : Long2ObjectOpenHashMap.this.value[i].equals(e.getValue()));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Long2ObjectOpenHashMap.this.findKey((Long)e.getKey());
            if (i >= 0) {
                Long2ObjectOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Long2ObjectOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Long2ObjectOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Long2ObjectMap.Entry<V>> {
        final AbstractLong2ObjectMap.BasicEntry<V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractLong2ObjectMap.BasicEntry<Object>(0L, null);
        }

        @Override
        public AbstractLong2ObjectMap.BasicEntry<V> next() {
            int e = this.nextEntry();
            this.entry.key = Long2ObjectOpenHashMap.this.key[e];
            this.entry.value = Long2ObjectOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Long2ObjectMap.Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Long2ObjectMap.Entry<V> next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Long2ObjectOpenHashMap.this.count;
            byte[] state = Long2ObjectOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Long2ObjectOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Long2ObjectOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Long2ObjectOpenHashMap.this.state[this.last] = 1;
            Long2ObjectOpenHashMap.this.value[this.last] = null;
            --Long2ObjectOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Long2ObjectMap.Entry<V>,
    Map.Entry<Long, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Long getKey() {
            return Long2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public long getLongKey() {
            return Long2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Long2ObjectOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Long2ObjectOpenHashMap.this.value[this.index];
            Long2ObjectOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2ObjectOpenHashMap.this.key[this.index] == (Long)e.getKey() && (Long2ObjectOpenHashMap.this.value[this.index] == null ? e.getValue() == null : Long2ObjectOpenHashMap.this.value[this.index].equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(Long2ObjectOpenHashMap.this.key[this.index]) ^ (Long2ObjectOpenHashMap.this.value[this.index] == null ? 0 : Long2ObjectOpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Long2ObjectOpenHashMap.this.key[this.index] + "->" + Long2ObjectOpenHashMap.this.value[this.index];
        }
    }
}

