/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.AbstractLong2IntFunction;
import it.unimi.dsi.fastutil.longs.Long2IntFunction;
import java.io.Serializable;

public class Long2IntFunctions {
    public static final EmptyFunction EMPTY_FUNCTION = new EmptyFunction();

    private Long2IntFunctions() {
    }

    public static Long2IntFunction singleton(long key, int value) {
        return new Singleton(key, value);
    }

    public static Long2IntFunction singleton(Long key, Integer value) {
        return new Singleton(key, value);
    }

    public static Long2IntFunction synchronize(Long2IntFunction f) {
        return new SynchronizedFunction(f);
    }

    public static Long2IntFunction synchronize(Long2IntFunction f, Object sync) {
        return new SynchronizedFunction(f, sync);
    }

    public static Long2IntFunction unmodifiable(Long2IntFunction f) {
        return new UnmodifiableFunction(f);
    }

    public static class UnmodifiableFunction
    extends AbstractLong2IntFunction
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2IntFunction function;

        protected UnmodifiableFunction(Long2IntFunction f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
        }

        public int size() {
            return this.function.size();
        }

        public boolean containsKey(long k) {
            return this.function.containsKey(k);
        }

        public int defaultReturnValue() {
            return this.defaultReturnValue();
        }

        public void defaultReturnValue(int defRetValue) {
            throw new UnsupportedOperationException();
        }

        public int put(long k, int v) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.function.toString();
        }

        public int remove(long k) {
            throw new UnsupportedOperationException();
        }

        public int get(long k) {
            return this.function.get(k);
        }

        public boolean containsKey(Object ok) {
            return this.function.containsKey(ok);
        }
    }

    public static class SynchronizedFunction
    extends AbstractLong2IntFunction
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2IntFunction function;
        protected final Object sync;

        protected SynchronizedFunction(Long2IntFunction f, Object sync) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = sync;
        }

        protected SynchronizedFunction(Long2IntFunction f) {
            if (f == null) {
                throw new NullPointerException();
            }
            this.function = f;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(long k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(int defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.function.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int put(long k, int v) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.function.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.function.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer put(Long k, Integer v) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer get(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.function.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer remove(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return (Integer)this.function.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int remove(long k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get(long k) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.function.containsKey(ok);
            }
        }
    }

    public static class Singleton
    extends AbstractLong2IntFunction
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final long key;
        protected final int value;

        protected Singleton(long key, int value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(long k) {
            return this.key == k;
        }

        public int get(long k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyFunction
    extends AbstractLong2IntFunction
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyFunction() {
        }

        public int get(long k) {
            return 0;
        }

        public boolean containsKey(long k) {
            return false;
        }

        public int defaultReturnValue() {
            return 0;
        }

        public void defaultReturnValue(int defRetValue) {
            throw new UnsupportedOperationException();
        }

        public Integer get(Object k) {
            return null;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_FUNCTION;
        }

        public Object clone() {
            return EMPTY_FUNCTION;
        }
    }
}

