/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2BooleanFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLong2BooleanMap
extends AbstractLong2BooleanFunction
implements Long2BooleanMap,
Serializable {
    public static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2BooleanMap() {
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Boolean)ov);
    }

    @Override
    public boolean containsValue(boolean v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(long k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Boolean> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Long, ? extends Boolean>> i = m.entrySet().iterator();
        if (m instanceof Long2BooleanMap) {
            while (n-- != 0) {
                Long2BooleanMap.Entry e = (Long2BooleanMap.Entry)i.next();
                this.put(e.getLongKey(), e.getBooleanValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Long, ? extends Boolean> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2BooleanMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            public void clear() {
                AbstractLong2BooleanMap.this.clear();
            }

            public LongIterator iterator() {
                return new AbstractLongIterator(){
                    final ObjectIterator<Map.Entry<Long, Boolean>> i;
                    {
                        this.i = AbstractLong2BooleanMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public BooleanCollection values() {
        return new AbstractBooleanCollection(){

            public boolean contains(boolean k) {
                return AbstractLong2BooleanMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            public void clear() {
                AbstractLong2BooleanMap.this.clear();
            }

            public BooleanIterator iterator() {
                return new AbstractBooleanIterator(){
                    final ObjectIterator<Map.Entry<Long, Boolean>> i;
                    {
                        this.i = AbstractLong2BooleanMap.this.entrySet().iterator();
                    }

                    public boolean nextBoolean() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Long, Boolean>> entrySet() {
        return this.long2BooleanEntrySet();
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2BooleanMap.Entry e = (Long2BooleanMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2BooleanMap.Entry {
        protected long key;
        protected boolean value;

        public BasicEntry(Long key, Boolean value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(long key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public Long getKey() {
            return this.key;
        }

        public long getLongKey() {
            return this.key;
        }

        public Boolean getValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public Boolean setValue(Boolean value) {
            return this.setValue((boolean)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Boolean)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

