/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ShortMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2ShortMap;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Double2ShortOpenHashMap
extends AbstractDouble2ShortMap
implements Serializable,
Cloneable,
Hash {
    protected transient double[] key;
    protected transient short[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Double2ShortMap.FastEntrySet entries;
    protected volatile transient DoubleSet keys;
    protected volatile transient ShortCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Double2ShortOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new double[this.free];
        this.value = new short[this.free];
        this.state = new byte[this.free];
    }

    public Double2ShortOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Double2ShortOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2ShortOpenHashMap(Map<? extends Double, ? extends Short> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ShortOpenHashMap(Map<? extends Double, ? extends Short> m) {
        this(m, 0.75f);
    }

    public Double2ShortOpenHashMap(Double2ShortMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ShortOpenHashMap(Double2ShortMap m) {
        this(m, 0.75f);
    }

    public Double2ShortOpenHashMap(double[] k, short[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2ShortOpenHashMap(double[] k, short[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(double k) {
        double[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public short put(double k, short v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Short put(Double ok, Short ov) {
        short v = ov;
        double k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(short v) {
        short[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    @Override
    public boolean containsKey(double k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public short get(double k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public short remove(double k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Short get(Double ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Short.valueOf(this.value[i]);
    }

    @Override
    public Short remove(Object ok) {
        int i = this.findKey((Double)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Double2ShortMap.FastEntrySet double2ShortEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ShortCollection values() {
        if (this.values == null) {
            this.values = new AbstractShortCollection(){

                public ShortIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Double2ShortOpenHashMap.this.count;
                }

                public boolean contains(short v) {
                    return Double2ShortOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Double2ShortOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        double[] key = this.key;
        double[] newKey = new double[newN];
        short[] value = this.value;
        short[] newValue = new short[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            double k = key[i];
            short v = value[i];
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Double2ShortOpenHashMap c;
        try {
            c = (Double2ShortOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (short[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        short[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeShort(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new double[n];
        double[] key = this.key;
        this.value = new short[n];
        short[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            double k = s.readDouble();
            short v = s.readShort();
            int k2i = HashCommon.double2int(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ShortIterator {
        public short nextShort() {
            return Double2ShortOpenHashMap.this.value[this.nextEntry()];
        }

        public Short next() {
            return Double2ShortOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSet {
        private KeySet() {
        }

        public DoubleIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Double2ShortOpenHashMap.this.count;
        }

        public boolean contains(double k) {
            return Double2ShortOpenHashMap.this.containsKey(k);
        }

        public boolean remove(double k) {
            int oldCount = Double2ShortOpenHashMap.this.count;
            Double2ShortOpenHashMap.this.remove(k);
            return Double2ShortOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Double2ShortOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleIterator {
        public double nextDouble() {
            return Double2ShortOpenHashMap.this.key[this.nextEntry()];
        }

        public Double next() {
            return Double2ShortOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Double2ShortMap.Entry>
    implements Double2ShortMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Double2ShortMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Double2ShortMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Double2ShortOpenHashMap.this.findKey((Double)e.getKey());
            return i >= 0 && Double2ShortOpenHashMap.this.value[i] == (Short)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Double2ShortOpenHashMap.this.findKey((Double)e.getKey());
            if (i >= 0) {
                Double2ShortOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Double2ShortOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Double2ShortOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Double2ShortMap.Entry> {
        final AbstractDouble2ShortMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractDouble2ShortMap.BasicEntry(0.0, 0);
        }

        @Override
        public AbstractDouble2ShortMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2ShortOpenHashMap.this.key[e];
            this.entry.value = Double2ShortOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Double2ShortMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Double2ShortMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Double2ShortOpenHashMap.this.count;
            byte[] state = Double2ShortOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Double2ShortOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Double2ShortOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Double2ShortOpenHashMap.this.state[this.last] = 1;
            --Double2ShortOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Double2ShortMap.Entry,
    Map.Entry<Double, Short> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        public Short getValue() {
            return Double2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short getShortValue() {
            return Double2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short setValue(short v) {
            short oldValue = Double2ShortOpenHashMap.this.value[this.index];
            Double2ShortOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Short setValue(Short v) {
            return this.setValue((short)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2ShortOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2ShortOpenHashMap.this.value[this.index] == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2ShortOpenHashMap.this.key[this.index]) ^ Double2ShortOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Double2ShortOpenHashMap.this.key[this.index] + "->" + Double2ShortOpenHashMap.this.value[this.index];
        }
    }
}

