/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.AbstractByte2DoubleMap;
import it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import it.unimi.dsi.fastutil.bytes.Byte2DoubleMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Byte2DoubleOpenHashMap
extends AbstractByte2DoubleMap
implements Serializable,
Cloneable,
Hash {
    protected transient byte[] key;
    protected transient double[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient Byte2DoubleMap.FastEntrySet entries;
    protected volatile transient ByteSet keys;
    protected volatile transient DoubleCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Byte2DoubleOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new byte[this.free];
        this.value = new double[this.free];
        this.state = new byte[this.free];
    }

    public Byte2DoubleOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Byte2DoubleOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2DoubleOpenHashMap(Map<? extends Byte, ? extends Double> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2DoubleOpenHashMap(Map<? extends Byte, ? extends Double> m) {
        this(m, 0.75f);
    }

    public Byte2DoubleOpenHashMap(Byte2DoubleMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2DoubleOpenHashMap(Byte2DoubleMap m) {
        this(m, 0.75f);
    }

    public Byte2DoubleOpenHashMap(byte[] k, double[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2DoubleOpenHashMap(byte[] k, double[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    protected final int findInsertionPoint(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    protected final int findKey(byte k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        byte[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public double put(byte k, double v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Double put(Byte ok, Double ov) {
        double v = ov;
        byte k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(double v) {
        double[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    @Override
    public boolean containsKey(byte k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public double get(byte k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public double remove(byte k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Double get(Byte ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Double.valueOf(this.value[i]);
    }

    @Override
    public Double remove(Object ok) {
        int i = this.findKey((Byte)ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Byte2DoubleMap.FastEntrySet byte2DoubleEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ByteSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public DoubleCollection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                public DoubleIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Byte2DoubleOpenHashMap.this.count;
                }

                public boolean contains(double v) {
                    return Byte2DoubleOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Byte2DoubleOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        byte[] state = this.state;
        int newN = PRIMES[newP];
        byte[] key = this.key;
        byte[] newKey = new byte[newN];
        double[] value = this.value;
        double[] newValue = new double[newN];
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            byte k = key[i];
            double v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Byte2DoubleOpenHashMap c;
        try {
            c = (Byte2DoubleOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= HashCommon.double2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        double[] value = this.value;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeDouble(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new byte[n];
        byte[] key = this.key;
        this.value = new double[n];
        double[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            byte k = s.readByte();
            double v = s.readDouble();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleIterator {
        public double nextDouble() {
            return Byte2DoubleOpenHashMap.this.value[this.nextEntry()];
        }

        public Double next() {
            return Byte2DoubleOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractByteSet {
        private KeySet() {
        }

        public ByteIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Byte2DoubleOpenHashMap.this.count;
        }

        public boolean contains(byte k) {
            return Byte2DoubleOpenHashMap.this.containsKey(k);
        }

        public boolean remove(byte k) {
            int oldCount = Byte2DoubleOpenHashMap.this.count;
            Byte2DoubleOpenHashMap.this.remove(k);
            return Byte2DoubleOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Byte2DoubleOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteIterator {
        public byte nextByte() {
            return Byte2DoubleOpenHashMap.this.key[this.nextEntry()];
        }

        public Byte next() {
            return Byte2DoubleOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Byte2DoubleMap.Entry>
    implements Byte2DoubleMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Byte2DoubleMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Byte2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2DoubleOpenHashMap.this.findKey((Byte)e.getKey());
            return i >= 0 && Byte2DoubleOpenHashMap.this.value[i] == (Double)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int i = Byte2DoubleOpenHashMap.this.findKey((Byte)e.getKey());
            if (i >= 0) {
                Byte2DoubleOpenHashMap.this.remove(e.getKey());
            }
            return i >= 0;
        }

        @Override
        public int size() {
            return Byte2DoubleOpenHashMap.this.count;
        }

        @Override
        public void clear() {
            Byte2DoubleOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Byte2DoubleMap.Entry> {
        final AbstractByte2DoubleMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractByte2DoubleMap.BasicEntry(0, 0.0);
        }

        @Override
        public AbstractByte2DoubleMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Byte2DoubleOpenHashMap.this.key[e];
            this.entry.value = Byte2DoubleOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Byte2DoubleMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Byte2DoubleMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Byte2DoubleOpenHashMap.this.count;
            byte[] state = Byte2DoubleOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Byte2DoubleOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Byte2DoubleOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Byte2DoubleOpenHashMap.this.state[this.last] = 1;
            --Byte2DoubleOpenHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Byte2DoubleMap.Entry,
    Map.Entry<Byte, Double> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Byte getKey() {
            return Byte2DoubleOpenHashMap.this.key[this.index];
        }

        @Override
        public byte getByteKey() {
            return Byte2DoubleOpenHashMap.this.key[this.index];
        }

        @Override
        public Double getValue() {
            return Byte2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double getDoubleValue() {
            return Byte2DoubleOpenHashMap.this.value[this.index];
        }

        @Override
        public double setValue(double v) {
            double oldValue = Byte2DoubleOpenHashMap.this.value[this.index];
            Byte2DoubleOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Double setValue(Double v) {
            return this.setValue((double)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2DoubleOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2DoubleOpenHashMap.this.value[this.index] == (Double)e.getValue();
        }

        @Override
        public int hashCode() {
            return Byte2DoubleOpenHashMap.this.key[this.index] ^ HashCommon.double2int(Byte2DoubleOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Byte2DoubleOpenHashMap.this.key[this.index] + "->" + Byte2DoubleOpenHashMap.this.value[this.index];
        }
    }
}

