/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntFunction;
import cern.jet.random.engine.MersenneTwister;

public abstract class RandomEngine
extends PersistentObject
implements DoubleFunction,
IntFunction {
    protected RandomEngine() {
    }

    public double apply(double dummy) {
        return this.raw();
    }

    public int apply(int dummy) {
        return this.nextInt();
    }

    public static RandomEngine makeDefault() {
        return new MersenneTwister((int)System.currentTimeMillis());
    }

    public double nextDouble() {
        double nextDouble;
        while (!((nextDouble = ((double)this.nextLong() - -9.223372036854776E18) * 5.421010862427522E-20) > 0.0) || !(nextDouble < 1.0)) {
        }
        return nextDouble;
    }

    public float nextFloat() {
        float nextFloat;
        while ((nextFloat = (float)this.raw()) >= 1.0f) {
        }
        return nextFloat;
    }

    public abstract int nextInt();

    public long nextLong() {
        return ((long)this.nextInt() & 0xFFFFFFFFL) << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    public double raw() {
        int nextInt;
        while ((nextInt = this.nextInt()) == 0) {
        }
        return (double)((long)nextInt & 0xFFFFFFFFL) * 2.3283064365386963E-10;
    }
}

